/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityMoneySpider;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import erebus.items.ItemErebusFood;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityTarantula
extends EntityMob {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityTarantula.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityTarantula.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityTarantula(World world) {
        super(world);
        this.func_70105_a(1.3f, 0.6f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN_TYPE, (Object)this.field_70146_Z.nextInt(3));
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 30.0 : 30.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 5.0 : 5.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 2;
    }

    public int func_70658_aO() {
        return 4;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            if (super.func_70652_k(entity) && entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.func_130014_f_().func_175659_aa().ordinal() > EnumDifficulty.EASY.ordinal()) {
                    if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL) {
                        duration = 5;
                    } else if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
                        duration = 10;
                    }
                }
                if (duration > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.func_70027_ad()) {
            this.func_70099_a(new ItemStack(ModItems.EREBUS_FOOD, 1 + this.field_70146_Z.nextInt(2 + looting), ItemErebusFood.EnumFoodType.TARANTULA_LEG_COOKED.ordinal()), 0.0f);
        } else {
            this.func_70099_a(new ItemStack(ModItems.EREBUS_FOOD, 1 + this.field_70146_Z.nextInt(2 + looting), ItemErebusFood.EnumFoodType.TARANTULA_LEG_RAW.ordinal()), 0.0f);
        }
        this.func_145779_a(Items.field_151070_bp, this.field_70146_Z.nextInt(2) + looting);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.func_130014_f_().field_73012_v.nextInt(100) == 0) {
            EntityMoneySpider moneyspider = new EntityMoneySpider(this.func_130014_f_());
            moneyspider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            moneyspider.func_180482_a(difficulty, null);
            this.func_130014_f_().func_72838_d((Entity)moneyspider);
            moneyspider.func_184220_m((Entity)this);
        }
        if (livingdata == null) {
            Potion potion;
            livingdata = new EntitySpider.GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((EntitySpider.GroupData)livingdata).func_111104_a(this.field_70170_p.field_73012_v);
            }
            if (livingdata instanceof EntitySpider.GroupData && (potion = ((EntitySpider.GroupData)livingdata).field_188478_a) != null) {
                this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
            }
        }
        return livingdata;
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("skin", this.getSkin());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("skin")) {
            this.setSkin(nbt.func_74762_e("skin"));
        } else {
            this.setSkin(this.field_70146_Z.nextInt(3));
        }
    }
}

