/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.helper.Utils;
import erebus.entity.EntityWasp;
import erebus.entity.ai.EntityAIFlyingWander;
import erebus.entity.ai.EntityAIPolinate;
import erebus.entity.ai.FlyingMoveHelper;
import erebus.entity.ai.PathNavigateFlying;
import erebus.items.ItemMaterials;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityWorkerBee
extends EntityTameable {
    public boolean beeFlying;
    public boolean beePollinating = false;
    public boolean beeCollecting = false;
    private static final DataParameter<Integer> DROP_POINT_X = EntityDataManager.func_187226_a(EntityWorkerBee.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DROP_POINT_Y = EntityDataManager.func_187226_a(EntityWorkerBee.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DROP_POINT_Z = EntityDataManager.func_187226_a(EntityWorkerBee.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> NECTAR_POINTS = EntityDataManager.func_187226_a(EntityWorkerBee.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> TAME_STATE = EntityDataManager.func_187226_a(EntityWorkerBee.class, (DataSerializer)DataSerializers.field_187191_a);
    private EntityAIFlyingWander aiFlyingWander;

    public EntityWorkerBee(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70765_h = new FlyingMoveHelper((EntityCreature)this);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DROP_POINT_X, (Object)0);
        this.field_70180_af.func_187214_a(DROP_POINT_Y, (Object)0);
        this.field_70180_af.func_187214_a(DROP_POINT_Z, (Object)0);
        this.field_70180_af.func_187214_a(NECTAR_POINTS, (Object)0);
        this.field_70180_af.func_187214_a(TAME_STATE, (Object)0);
    }

    protected void func_184651_r() {
        this.aiFlyingWander = new EntityAIFlyingWander((EntityCreature)this, 0.5, 20);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPolinate((EntityLiving)this, 10));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.3, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWasp.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_130014_f_().func_72855_b(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.func_130014_f_().func_72953_d(this.func_174813_aQ());
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    protected boolean func_70692_ba() {
        return this.getTameState() == 0;
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    public void func_70071_h_() {
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.4;
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.field_70173_aa == 1 && this.getTameState() == 0) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiFlyingWander);
            }
            if (this.beeCollecting && !this.beePollinating) {
                this.func_70661_as().func_75492_a((double)this.getDropPointX() + 0.5, (double)this.getDropPointY() + 1.0, (double)this.getDropPointZ() + 0.5, 0.25);
            }
            if (this.func_70011_f((double)this.getDropPointX() + 0.5, (double)this.getDropPointY() + 0.5, (double)this.getDropPointZ() + 0.5) < 1.0 && this.getNectarPoints() > 0) {
                this.addHoneyToInventory(this.getDropPointX(), this.getDropPointY(), this.getDropPointZ());
                this.setBeeCollecting(false);
                this.func_70661_as().func_75499_g();
            }
            if (this.func_70090_H()) {
                this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.32);
            }
        }
        super.func_70071_h_();
    }

    private void addHoneyToInventory(int x, int y, int z) {
        if (Utils.addItemStackToInventory(Utils.getTileEntity((IBlockAccess)this.func_130014_f_(), new BlockPos(x, y, z), IInventory.class), ItemMaterials.EnumErebusMaterialsType.NECTAR.createStack(this.getNectarPoints()))) {
            this.setNectarPoints(0);
        }
    }

    public void setBeeFlying(boolean state) {
        this.beeFlying = state;
    }

    public void setBeePollinating(boolean state) {
        this.beePollinating = state;
    }

    public void setBeeCollecting(boolean state) {
        this.beeCollecting = state;
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateFlying((EntityLiving)this, world);
    }

    public void flyAbout() {
        this.flyToTarget();
    }

    public void flyToTarget() {
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    private void land() {
    }

    public boolean func_145773_az() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.WASP_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.WASP_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (recentlyHit) {
            this.func_70099_a(ItemMaterials.EnumErebusMaterialsType.NECTAR.createStack(2), 0.0f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!this.func_130014_f_().field_72995_K && !stack.func_190926_b() && stack.func_77973_b() == ModItems.NECTAR_COLLECTOR && this.getNectarPoints() > 0) {
            this.func_70099_a(ItemMaterials.EnumErebusMaterialsType.NECTAR.createStack(2), 0.0f);
            stack.func_77972_a(1, (EntityLivingBase)player);
            this.setNectarPoints(this.getNectarPoints() - 2);
            return true;
        }
        if (stack != null && stack.func_77973_b() == ModItems.BEE_TAMING_AMULET && stack.func_77942_o() && stack.func_77978_p().func_74764_b("homeX")) {
            if (!this.func_130014_f_().field_72995_K) {
                this.setDropPoint(stack.func_77978_p().func_74762_e("homeX"), stack.func_77978_p().func_74762_e("homeY"), stack.func_77978_p().func_74762_e("homeZ"));
                this.setTameState((byte)1);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFlyingWander);
                this.func_70624_b(null);
            }
            this.func_70908_e(true);
            player.func_184609_a(hand);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void setDropPoint(int x, int y, int z) {
        this.field_70180_af.func_187227_b(DROP_POINT_X, (Object)x);
        this.field_70180_af.func_187227_b(DROP_POINT_Y, (Object)y);
        this.field_70180_af.func_187227_b(DROP_POINT_Z, (Object)z);
    }

    public int getDropPointX() {
        return (Integer)this.field_70180_af.func_187225_a(DROP_POINT_X);
    }

    public int getDropPointY() {
        return (Integer)this.field_70180_af.func_187225_a(DROP_POINT_Y);
    }

    public int getDropPointZ() {
        return (Integer)this.field_70180_af.func_187225_a(DROP_POINT_Z);
    }

    public void setTameState(byte state) {
        this.field_70180_af.func_187227_b(TAME_STATE, (Object)state);
    }

    public byte getTameState() {
        return (Byte)this.field_70180_af.func_187225_a(TAME_STATE);
    }

    public void setNectarPoints(int count) {
        this.field_70180_af.func_187227_b(NECTAR_POINTS, (Object)count);
    }

    public int getNectarPoints() {
        return (Integer)this.field_70180_af.func_187225_a(NECTAR_POINTS);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("nectarPoints", this.getNectarPoints());
        nbt.func_74774_a("tameState", this.getTameState());
        nbt.func_74768_a("dropPointX", this.getDropPointX());
        nbt.func_74768_a("dropPointY", this.getDropPointY());
        nbt.func_74768_a("dropPointZ", this.getDropPointZ());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setNectarPoints(nbt.func_74762_e("nectarPoints"));
        this.setTameState(nbt.func_74771_c("tameState"));
        this.setDropPoint(nbt.func_74762_e("dropPointX"), nbt.func_74762_e("dropPointY"), nbt.func_74762_e("dropPointZ"));
    }
}

