/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import com.google.common.collect.ImmutableList;
import erebus.Erebus;
import erebus.ModItems;
import erebus.ModMaterials;
import erebus.ModSounds;
import erebus.ModTabs;
import erebus.core.helper.NBTHelper;
import erebus.items.ItemMaterials;
import erebus.network.client.PacketParticle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWarHammer
extends ItemSword {
    private static final ImmutableList<String> STACK_NBT_EXCLUSIONS = ImmutableList.of((Object)"charge");

    public ItemWarHammer() {
        super(ModMaterials.WEAPON_WAR_HAMMER);
        this.func_77625_d(1);
        this.func_77637_a(ModTabs.GEAR);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
        list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.erebus.warhammer_1", new Object[0]).func_150254_d());
        list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.erebus.warhammer_2", new Object[0]).func_150254_d());
    }

    public boolean func_82789_a(ItemStack armour, ItemStack material) {
        return material.func_77973_b() == ModItems.MATERIALS && material.func_77952_i() == ItemMaterials.EnumErebusMaterialsType.REINFORCED_PLATE_EXO.ordinal();
    }

    public boolean func_77644_a(ItemStack is, EntityLivingBase entity, EntityLivingBase player) {
        is.func_77972_a(1, player);
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (this.hasTag(stack) && !stack.func_77978_p().func_74764_b("charge")) {
            stack.func_77978_p().func_74768_a("charge", 0);
        }
    }

    public int func_77626_a(ItemStack is) {
        return 1000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77978_p().func_74762_e("charge") < 25) {
            stack.func_77978_p().func_74768_a("charge", stack.func_77978_p().func_74762_e("charge") + 1);
        }
        if (stack.func_77978_p().func_74762_e("charge") >= 25) {
            stack.func_77978_p().func_74768_a("charge", 25);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasTag(stack) && facing == EnumFacing.UP && player.func_70093_af()) {
            if (stack.func_77978_p().func_74762_e("charge") > 0) {
                Erebus.NETWORK_WRAPPER.sendToAll((IMessage)new PacketParticle(PacketParticle.ParticleType.HAMMER_BLAM, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v));
                world.func_184133_a(null, pos, ModSounds.BLAM_SOUND, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            this.areaOfEffect(world, stack, player);
            stack.func_77978_p().func_74768_a("charge", 0);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    protected Entity areaOfEffect(World world, ItemStack stack, EntityPlayer player) {
        List list = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(player.func_174813_aQ().field_72340_a, player.func_174813_aQ().field_72338_b, player.func_174813_aQ().field_72339_c, player.func_174813_aQ().field_72336_d, player.func_174813_aQ().field_72337_e, player.func_174813_aQ().field_72334_f).func_72314_b((double)stack.func_77978_p().func_74762_e("charge") * 0.25, 1.0, (double)stack.func_77978_p().func_74762_e("charge") * 0.25));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityLivingBase) || entity == player) continue;
            float Knockback = (float)((double)stack.func_77978_p().func_74762_e("charge") * 0.025);
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), (float)stack.func_77978_p().func_74762_e("charge") * 0.25f);
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * -3.141593f + (float)world.field_73012_v.nextInt(3) + 7.8662776E-4f)) * Knockback), 0.01, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * -3.141593f + (float)world.field_73012_v.nextInt(3) + 7.8662776E-4f)) * Knockback));
        }
        return null;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean wasCharging = oldStack.func_77978_p() != null && oldStack.func_77978_p().func_74762_e("charge") <= 25;
        boolean isCharging = newStack.func_77978_p() != null && newStack.func_77978_p().func_74762_e("charge") <= 25;
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && !isCharging || isCharging != wasCharging || !NBTHelper.areItemStackTagsEqual(oldStack, newStack, STACK_NBT_EXCLUSIONS);
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }
}

