/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.ModItems;
import erebus.blocks.BlockLiquifier;
import erebus.items.ItemMaterials;
import erebus.tileentity.FluidTankTile;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityLiquifier
extends TileEntityBasicInventory
implements ITickable {
    private IItemHandler itemHandler;
    public FluidTankTile tank = new FluidTankTile(null, 8000);
    public boolean active;
    public int operatingTime;
    public int animationTicks;
    public int prevAnimationTicks;
    private static final int[] SLOTS = new int[]{0};

    public TileEntityLiquifier() {
        super(1, "Liquifier");
        this.tank.setTileEntity(this);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K && this.active) {
            this.prevAnimationTicks = this.animationTicks;
            if (this.animationTicks < 360) {
                this.animationTicks += 18;
            }
            if (this.animationTicks >= 360) {
                this.animationTicks -= 360;
                this.prevAnimationTicks -= 360;
            }
        }
        if (!this.func_145831_w().field_72995_K && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() != null) {
            if (((Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockLiquifier.POWERED)).booleanValue()) {
                boolean isDirty = false;
                if (!((ItemStack)this.getInventory().get(0)).func_190926_b()) {
                    if (this.canOperate()) {
                        ++this.operatingTime;
                        if (this.operatingTime >= 180) {
                            this.operatingTime = 0;
                            this.liquifyItem();
                            isDirty = true;
                        }
                    } else {
                        this.operatingTime = 0;
                    }
                }
                if (isDirty) {
                    this.func_70296_d();
                }
            } else if (this.operatingTime != 0) {
                this.operatingTime = 0;
            }
        }
    }

    private boolean canOperate() {
        if (((ItemStack)this.getInventory().get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = (ItemStack)this.getInventory().get(0);
        return this.func_94041_b(0, itemstack) && this.tank.getFluidAmount() <= this.tank.getCapacity() - 50 && (this.tank.getFluid() == null || this.tank.getFluid().containsFluid(new FluidStack(FluidRegistry.getFluid((String)"honey"), 0)));
    }

    public void liquifyItem() {
        if (this.canOperate() && (this.tank.getFluid() == null || this.tank.getFluid().containsFluid(new FluidStack(FluidRegistry.getFluid((String)"honey"), 0))) && this.tank.getFluidAmount() <= this.tank.getCapacity() - 50) {
            this.tank.fill(new FluidStack(FluidRegistry.getFluid((String)"honey"), 50), true);
            ((ItemStack)this.getInventory().get(0)).func_190918_g(1);
            if (((ItemStack)this.getInventory().get(0)).func_190916_E() <= 0) {
                this.getInventory().set(0, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("active", this.active);
        this.tank.writeToNBT(nbt);
        nbt.func_74777_a("operatingTime", (short)this.operatingTime);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.active = nbt.func_74767_n("active");
        this.tank.readFromNBT(nbt);
        this.operatingTime = nbt.func_74765_d("operatingTime");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        return this.func_189515_b(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
        this.tank.onContentsChanged();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() == ModItems.MATERIALS && stack.func_77952_i() == ItemMaterials.EnumErebusMaterialsType.HONEY_DRIP.ordinal();
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        return super.getCapability(capability, facing);
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getOperationProgressScaled(int time) {
        return this.operatingTime * time / 180;
    }
}

