/*
 * Decompiled with CFR 0.152.
 */
package erebus.world;

import erebus.ModBiomes;
import erebus.world.biomes.BiomeBaseErebus;
import erebus.world.genlayer.GenLayerErebus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeProviderErebus
extends BiomeProvider {
    private static final float rainfall = 0.0f;
    private static final List<BiomeBaseErebus> allowedBiomes = Arrays.asList(ModBiomes.ELYSIAN_FIELDS);
    private final List<Biome> biomesToSpawnIn = new ArrayList<BiomeBaseErebus>(allowedBiomes);
    private final BiomeCache biomeCache = new BiomeCache((BiomeProvider)this);
    private final GenLayer biomeGenLayer;

    public BiomeProviderErebus(World world) {
        this.biomeGenLayer = GenLayerErebus.initializeAllBiomeGenerators(world.func_72905_C(), world.func_72912_H().func_76067_t())[1];
    }

    public Biome[] func_76937_a(Biome[] biomesForGeneration, int x, int z, int sizeX, int sizeZ) {
        IntCache.func_76446_a();
        if (biomesForGeneration == null || biomesForGeneration.length < sizeX * sizeZ) {
            biomesForGeneration = new Biome[sizeX * sizeZ];
        }
        int[] biomeArray = this.biomeGenLayer.func_75904_a(x, z, sizeX, sizeZ);
        for (int index = 0; index < sizeX * sizeZ; ++index) {
            biomesForGeneration[index] = Biome.func_180276_a((int)biomeArray[index], (Biome)Biomes.field_180279_ad);
        }
        return biomesForGeneration;
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] biomesForGeneration, int x, int z, int sizeX, int sizeZ, boolean useCache) {
        IntCache.func_76446_a();
        if (biomesForGeneration == null || biomesForGeneration.length < sizeX * sizeZ) {
            biomesForGeneration = new Biome[sizeX * sizeZ];
        }
        if (useCache && sizeX == 16 && sizeZ == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] cachedBiomes = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(cachedBiomes, 0, biomesForGeneration, 0, sizeX * sizeZ);
            return biomesForGeneration;
        }
        int[] generatedBiomes = this.biomeGenLayer.func_75904_a(x, z, sizeX, sizeZ);
        for (int index = 0; index < sizeX * sizeZ; ++index) {
            biomesForGeneration[index] = Biome.func_180276_a((int)generatedBiomes[index], (Biome)Biomes.field_180279_ad);
        }
        return biomesForGeneration;
    }

    public BlockPos func_180630_a(int x, int z, int checkRadius, List viableBiomes, Random rand) {
        IntCache.func_76446_a();
        int minX = x - checkRadius >> 2;
        int minZ = z - checkRadius >> 2;
        int maxX = x + checkRadius >> 2;
        int maxZ = z + checkRadius >> 2;
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        int[] biomeArray = this.biomeGenLayer.func_75904_a(minX, minZ, sizeX, sizeZ);
        BlockPos pos = null;
        int attempts = 0;
        for (int index = 0; index < sizeX * sizeZ; ++index) {
            int finalX = minX + index % sizeX << 2;
            int finalZ = minZ + index / sizeX << 2;
            if (!viableBiomes.contains(Biome.func_180276_a((int)biomeArray[index], (Biome)Biomes.field_180279_ad)) || pos != null && rand.nextInt(attempts + 1) != 0) continue;
            pos = new BlockPos(finalX, 0, finalZ);
            ++attempts;
        }
        return pos;
    }

    public boolean func_76940_a(int x, int z, int checkRadius, List viableBiomes) {
        IntCache.func_76446_a();
        int minX = x - checkRadius >> 2;
        int minZ = z - checkRadius >> 2;
        int maxX = x + checkRadius >> 2;
        int maxZ = z + checkRadius >> 2;
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        int[] biomeArray = this.biomeGenLayer.func_75904_a(minX, minZ, sizeX, sizeZ);
        for (int index = 0; index < sizeX * sizeZ; ++index) {
            if (viableBiomes.contains(Biome.func_180276_a((int)biomeArray[index], (Biome)Biomes.field_180279_ad))) continue;
            return false;
        }
        return true;
    }

    public List<Biome> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.getNewBiomeGens();
    }
}

