/*
 * Decompiled with CFR 0.152.
 */
package erebus.world;

import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.blocks.BlockDoubleHeightPlant;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.SpawnerErebus;
import erebus.world.biomes.BiomeBaseErebus;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.structure.WorldGenAntlionDungeon;
import erebus.world.feature.structure.WorldGenSpiderDungeons;
import erebus.world.feature.tree.WorldGenGiantEucalyptus;
import erebus.world.mapgen.MapGenErebusCaves;
import erebus.world.mapgen.MapGenErebusRavine;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderErebus
implements IChunkGenerator,
IChunkProvider {
    private final World worldObj;
    private final Random rand;
    private final NoiseGeneratorOctaves noiseGen1;
    private final NoiseGeneratorOctaves noiseGen2;
    private final NoiseGeneratorOctaves noiseGen3;
    private final NoiseGeneratorOctaves noiseGen4;
    private final NoiseGeneratorOctaves noiseGen5;
    private final NoiseGeneratorOctaves noiseGen6;
    private double[] noiseArray;
    private double[] stoneNoise;
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private double[] noiseData5;
    private NoiseGeneratorPerlin perlinAdditional1;
    private NoiseGeneratorPerlin perlinAdditional2;
    private Biome[] biomesForGeneration;
    private final MapGenBase caveGenerator;
    private final MapGenBase ravineGenerator;
    public static int swampWaterHeight = 24;

    public ChunkProviderErebus(World world, long seed) {
        this.worldObj = world;
        this.rand = new Random(seed + 1L);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinAdditional1 = new NoiseGeneratorPerlin(this.rand, 4);
        this.perlinAdditional2 = new NoiseGeneratorPerlin(this.rand, 4);
        this.stoneNoise = new double[256];
        this.caveGenerator = new MapGenErebusCaves();
        this.ravineGenerator = new MapGenErebusRavine();
    }

    public void generateTerrain(int x, int z, ChunkPrimer chunkPrimer) {
        int i = 4;
        int k = i + 1;
        int l = 17;
        int i1 = i + 1;
        this.noiseArray = this.initializeNoiseField(this.noiseArray, x * i, 0, z * i, k, l, i1);
        for (int j1 = 0; j1 < i; ++j1) {
            for (int k1 = 0; k1 < i; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d0 = 0.125;
                    double d1 = this.noiseArray[((j1 + 0) * i1 + k1 + 0) * l + l1 + 0];
                    double d2 = this.noiseArray[((j1 + 0) * i1 + k1 + 1) * l + l1 + 0];
                    double d3 = this.noiseArray[((j1 + 1) * i1 + k1 + 0) * l + l1 + 0];
                    double d4 = this.noiseArray[((j1 + 1) * i1 + k1 + 1) * l + l1 + 0];
                    double d5 = (this.noiseArray[((j1 + 0) * i1 + k1 + 0) * l + l1 + 1] - d1) * d0;
                    double d6 = (this.noiseArray[((j1 + 0) * i1 + k1 + 1) * l + l1 + 1] - d2) * d0;
                    double d7 = (this.noiseArray[((j1 + 1) * i1 + k1 + 0) * l + l1 + 1] - d3) * d0;
                    double d8 = (this.noiseArray[((j1 + 1) * i1 + k1 + 1) * l + l1 + 1] - d4) * d0;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (d15 > 0.0) {
                                    iblockstate = ModBlocks.UMBERSTONE.func_176223_P();
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                chunkPrimer.func_177855_a(l2, i3, j3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.generateTerrain(x, z, chunkprimer);
        this.replaceBlocksForBiome(x, z, this.biomesForGeneration, chunkprimer);
        this.caveGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        this.ravineGenerator.func_186125_a(this.worldObj, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] biomeArrayReference = chunk.func_76605_m();
        for (int a = 0; a < biomeArrayReference.length; ++a) {
            biomeArrayReference[a] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[a]);
        }
        chunk.func_76603_b();
        chunk.func_76613_n();
        return chunk;
    }

    private double[] initializeNoiseField(double[] noise, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        if (noise == null) {
            noise = new double[sizeX * sizeY * sizeZ];
        }
        double d = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.noiseGen5.func_76304_a(this.noiseData4, x, y, z, sizeX, 1, sizeZ, 1.0, 0.0, 1.0);
        this.noiseData5 = this.noiseGen6.func_76304_a(this.noiseData5, x, y, z, sizeX, 1, sizeZ, 100.0, 0.0, 100.0);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, x, y, z, sizeX, sizeY, sizeZ, d * 0.0125, d1 / 60.0, d * 0.0125);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, x, y, z, sizeX, sizeY, sizeZ, d, d1, d);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, x, y, z, sizeX, sizeY, sizeZ, d, d1, d);
        int index = 0;
        int j = 0;
        double[] ad = new double[sizeY];
        double oneOver512 = 0.001953125;
        double groundNoiseMp = 4.8828125E-4;
        for (int k = 0; k < sizeY; ++k) {
            ad[k] = Math.cos((double)k * Math.PI * 6.0 / (double)sizeY) * 2.0;
            double d2 = k;
            if (k > sizeY / 2) {
                d2 = sizeY - 1 - k;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = k;
            ad[n] = ad[n] - d2 * d2 * d2 * 10.0;
        }
        for (int xx = 0; xx < sizeX; ++xx) {
            for (int zz = 0; zz < sizeZ; ++zz) {
                double d3 = (this.noiseData4[j] + 256.0) * oneOver512;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[j] * 1.25E-4;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 *= 0.5;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)sizeY * 0.0625;
                ++j;
                for (int yy = 0; yy < sizeY; ++yy) {
                    double d6 = 0.0;
                    double d7 = ad[yy];
                    double d8 = this.noiseData2[index] * groundNoiseMp;
                    double d9 = this.noiseData3[index] * groundNoiseMp;
                    double d10 = (this.noiseData1[index] * 0.1 + 1.0) * 0.5;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (yy > sizeY - 4) {
                        double d11 = (float)(yy - (sizeY - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)yy < d4) {
                        double d12 = (d4 - (double)yy) * 0.25;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    noise[index] = d6;
                    ++index;
                }
            }
        }
        return noise;
    }

    public void replaceBlocksForBiome(int x, int z, Biome[] biomes, ChunkPrimer primer) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks((IChunkGenerator)this, x, z, primer, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        int var5 = 0;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, x * 16, 0, z * 16, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        double d0 = 0.03125;
        double[] additionalNoise1 = new double[256];
        double[] additionalNoise2 = new double[256];
        additionalNoise1 = this.perlinAdditional1.func_151599_a(additionalNoise1, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        additionalNoise2 = this.perlinAdditional2.func_151599_a(additionalNoise2, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                int h2;
                int h;
                int horIndex = xInChunk + zInChunk * 16;
                BiomeBaseErebus biome = (BiomeBaseErebus)biomes[horIndex];
                int var12 = (int)(this.stoneNoise[xInChunk + zInChunk * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                IBlockState topBlock = biome.field_76752_A;
                IBlockState fillerBlock = biome.field_76753_B;
                int preHeightIndex = (xInChunk * 16 + zInChunk) * 128;
                if (biome == ModBiomes.SUBMERGED_SWAMP) {
                    if (additionalNoise1[horIndex] > 0.0) {
                        h = this.getLowestAirBlock(primer, xInChunk, zInChunk, preHeightIndex, 25, 35);
                        if (h > swampWaterHeight) {
                            h += 0;
                            while ((double)h > 23.08 - additionalNoise1[horIndex]) {
                                if (h == swampWaterHeight && this.rand.nextInt(32) == 0) {
                                    primer.func_177855_a(xInChunk, h + 1, zInChunk, Blocks.field_150392_bi.func_176223_P());
                                }
                                if (h <= swampWaterHeight) {
                                    primer.func_177855_a(xInChunk, h, zInChunk, Blocks.field_150355_j.func_176223_P());
                                    if (additionalNoise1[horIndex] < 0.08) {
                                        if (ConfigHandler.INSTANCE.generateVents && this.rand.nextInt(25) == 0) {
                                            primer.func_177855_a(xInChunk, h, zInChunk, Blocks.field_150428_aP.func_176223_P());
                                        } else {
                                            primer.func_177855_a(xInChunk, h, zInChunk, ModBlocks.UMBERSTONE.func_176223_P());
                                        }
                                    } else if (additionalNoise1[horIndex] < 0.5) {
                                        primer.func_177855_a(xInChunk, h - 1, zInChunk, Blocks.field_150354_m.func_176223_P());
                                    } else if (additionalNoise1[horIndex] <= 2.0) {
                                        primer.func_177855_a(xInChunk, h - 2, zInChunk, ModBlocks.QUICK_SAND.func_176223_P());
                                    } else if (additionalNoise2[horIndex] > 2.0) {
                                        primer.func_177855_a(xInChunk, h - 3, zInChunk, ModBlocks.MUD.func_176223_P());
                                    } else {
                                        primer.func_177855_a(xInChunk, h - 4, zInChunk, Blocks.field_150435_aG.func_176223_P());
                                        primer.func_177855_a(xInChunk, h, zInChunk, Blocks.field_150355_j.func_176223_P());
                                    }
                                } else {
                                    primer.func_177855_a(xInChunk, h, zInChunk, Blocks.field_150350_a.func_176223_P());
                                }
                                --h;
                            }
                        }
                    } else if (additionalNoise1[horIndex] > -0.15 && (h = this.getLowestAirBlock(primer, xInChunk, zInChunk, preHeightIndex, 25, 30)) > swampWaterHeight) {
                        h += 0;
                        while (h >= (2 + h) / 2) {
                            primer.func_177855_a(xInChunk, h, zInChunk, ModBlocks.MUD.func_176223_P());
                            --h;
                        }
                        if (++h >= swampWaterHeight && this.rand.nextInt(8) == 0 && primer.func_177856_a(xInChunk, preHeightIndex + h + 1, zInChunk) == Blocks.field_150350_a.func_176223_P() && primer.func_177856_a(xInChunk, preHeightIndex + h + 2, zInChunk) == Blocks.field_150350_a.func_176223_P()) {
                            primer.func_177855_a(xInChunk, preHeightIndex + h + 1, zInChunk, ModBlocks.DOUBLE_PLANT.func_176223_P().func_177226_a(BlockDoubleHeightPlant.HALF, (Comparable)((Object)BlockDoubleHeightPlant.EnumBlockHalf.LOWER)).func_177226_a(BlockDoubleHeightPlant.VARIANT, (Comparable)((Object)BlockDoubleHeightPlant.EnumPlantType.BULLRUSH)));
                            primer.func_177855_a(xInChunk, preHeightIndex + h + 2, zInChunk, ModBlocks.DOUBLE_PLANT.func_176223_P().func_177226_a(BlockDoubleHeightPlant.HALF, (Comparable)((Object)BlockDoubleHeightPlant.EnumBlockHalf.UPPER)));
                        }
                    }
                }
                if (biome == ModBiomes.VOLCANIC_DESERT && Math.abs(additionalNoise1[horIndex]) < 1.0 && (h = this.getLowestAirBlock(primer, xInChunk, zInChunk, preHeightIndex, 25, 32)) > 0) {
                    primer.func_177855_a(xInChunk, preHeightIndex + h, zInChunk, Blocks.field_150350_a.func_176223_P());
                    h2 = h - 1;
                    while ((double)h2 > (double)(h - 1) - 3.0 * (1.0 - Math.abs(additionalNoise1[horIndex]))) {
                        primer.func_177855_a(xInChunk, h2, zInChunk, Blocks.field_150356_k.func_176223_P());
                        --h2;
                    }
                }
                if (biome == ModBiomes.ELYSIAN_FIELDS && Math.abs(additionalNoise1[horIndex]) < 1.0 && (h = this.getLowestAirBlock(primer, xInChunk, zInChunk, preHeightIndex, 25, 26)) > 0) {
                    primer.func_177855_a(xInChunk, preHeightIndex + h, zInChunk, Blocks.field_150350_a.func_176223_P());
                    h2 = h - 1;
                    while ((double)h2 > (double)(h - 1) - 3.0 * (1.0 - Math.abs(additionalNoise1[horIndex]))) {
                        primer.func_177855_a(xInChunk, h2, zInChunk, Blocks.field_150355_j.func_176223_P());
                        --h2;
                    }
                }
                if (biome == ModBiomes.PETRIFIED_FOREST && Math.abs(additionalNoise1[horIndex]) < 1.0 && (h = this.getLowestAirBlock(primer, xInChunk, zInChunk, preHeightIndex, 25, 25)) > 0) {
                    primer.func_177855_a(xInChunk, preHeightIndex + h, zInChunk, Blocks.field_150350_a.func_176223_P());
                    h2 = h - 1;
                    while ((double)h2 > (double)(h - 1) - 3.0 * (1.0 - Math.abs(additionalNoise1[horIndex]))) {
                        primer.func_177855_a(xInChunk, h2, zInChunk, ModBlocks.FORMIC_ACID.func_176223_P());
                        --h2;
                    }
                }
                for (int yInChunk = 127; yInChunk >= 0; --yInChunk) {
                    IBlockState iblockstate2;
                    int index = (xInChunk * 16 + zInChunk) * 128 + yInChunk;
                    if (yInChunk == 0 || yInChunk == 127) {
                        primer.func_177855_a(xInChunk, yInChunk, zInChunk, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (!ConfigHandler.smoothBedrock && (yInChunk <= 5 && yInChunk <= 1 + this.rand.nextInt(5) || yInChunk >= 122 && yInChunk >= 126 - this.rand.nextInt(5))) {
                        primer.func_177855_a(xInChunk, yInChunk, zInChunk, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    if (biome == ModBiomes.SUBMERGED_SWAMP && yInChunk < swampWaterHeight && primer.func_177856_a(xInChunk, yInChunk, zInChunk) == Blocks.field_150350_a && primer.func_177856_a(xInChunk, yInChunk - 1, zInChunk).func_185914_p() && yInChunk < swampWaterHeight - 1) {
                        primer.func_177855_a(xInChunk, yInChunk, zInChunk, Blocks.field_150355_j.func_176223_P());
                    }
                    if ((iblockstate2 = primer.func_177856_a(xInChunk, yInChunk, zInChunk)).func_185904_a() == Material.field_151579_a) {
                        var13 = -1;
                        continue;
                    }
                    if (iblockstate2.func_177230_c().func_176223_P() != ModBlocks.UMBERSTONE.func_176223_P() || var13 != -1) continue;
                    if (var12 <= 0) {
                        topBlock = Blocks.field_150350_a.func_176223_P();
                        fillerBlock = ModBlocks.UMBERSTONE.func_176223_P();
                    } else if (yInChunk >= var5 + 4 && yInChunk <= var5 + 120) {
                        topBlock = biome.field_76752_A;
                        fillerBlock = biome.field_76753_B;
                    }
                    if (yInChunk < var5 && topBlock.func_185904_a() == Material.field_151579_a) {
                        topBlock = biome.func_185353_n() < 0.15f ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_150355_j.func_176223_P();
                    }
                    primer.func_177855_a(xInChunk, yInChunk, zInChunk, fillerBlock);
                    primer.func_177855_a(xInChunk, yInChunk + 1, zInChunk, topBlock);
                    var13 = var12;
                }
            }
        }
    }

    private int getLowestAirBlock(ChunkPrimer primer, int xInChunk, int zInChunk, int preHeightIndex, int minH, int maxH) {
        for (int h = Math.min(minH, maxH); h <= Math.max(minH, maxH); ++h) {
            IBlockState iblockstate = primer.func_177856_a(xInChunk, h, zInChunk);
            if (primer.func_177856_a(xInChunk, h, zInChunk).func_185904_a() != Material.field_151579_a) continue;
            return h;
        }
        return -1;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockCoord = new BlockPos(i, 0, j);
        Biome biomeBase = this.worldObj.func_180494_b(blockCoord.func_177982_a(16, 0, 16));
        if (biomeBase instanceof BiomeBaseErebus) {
            BiomeBaseErebus biome = (BiomeBaseErebus)biomeBase;
            this.rand.setSeed(this.worldObj.func_72905_C());
            this.rand.setSeed((long)x * (this.rand.nextLong() / 2L * 2L + 1L) + (long)z * (this.rand.nextLong() / 2L * 2L + 1L) ^ this.worldObj.func_72905_C());
            biome.populate(this.worldObj, this.rand, blockCoord.func_177958_n(), blockCoord.func_177952_p());
            biome.decorate(this.worldObj, this.rand, blockCoord.func_177958_n(), blockCoord.func_177952_p());
            SpawnerErebus.onChunkPopulate(this.worldObj, this.rand, biome, blockCoord.func_177958_n() + 8, blockCoord.func_177952_p() + 8);
        }
        WorldGenAntlionDungeon maze = new WorldGenAntlionDungeon();
        if (biomeBase == ModBiomes.VOLCANIC_DESERT) {
            maze.func_180709_b(this.worldObj, this.rand, new BlockPos(blockCoord.func_177958_n() + 16, 18, blockCoord.func_177952_p() + 16));
        }
        WorldGenGiantEucalyptus giant_baobab = new WorldGenGiantEucalyptus();
        if (biomeBase == ModBiomes.ULTERIOR_OUTBACK) {
            for (int yUp = 16; yUp <= 80; ++yUp) {
                BlockPos pos = new BlockPos(blockCoord.func_177958_n() + 16, yUp, blockCoord.func_177952_p() + 16);
                if (!this.checkSurface(SurfaceType.MIXED, pos)) continue;
                giant_baobab.func_180709_b(this.worldObj, this.rand, pos);
                break;
            }
        }
        for (int attempt = 0; attempt < 14; ++attempt) {
            new WorldGenSpiderDungeons().func_180709_b(this.worldObj, this.rand, new BlockPos(blockCoord.func_177958_n() + this.rand.nextInt(16) + 8, this.rand.nextInt(128), blockCoord.func_177952_p() + this.rand.nextInt(16) + 8));
        }
        BlockFalling.field_149832_M = false;
    }

    protected boolean checkSurface(SurfaceType surfaceType, BlockPos pos) {
        return surfaceType.matchBlock(this.worldObj.func_180495_p(pos));
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.worldObj.func_180494_b(pos);
        return biome == null ? null : biome.func_76747_a(creatureType);
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public Chunk func_186026_b(int x, int z) {
        return null;
    }

    public Chunk func_186025_d(int x, int z) {
        return null;
    }

    public boolean func_73156_b() {
        return false;
    }

    public String func_73148_d() {
        return "Erebus";
    }

    public boolean func_191062_e(int x, int z) {
        return false;
    }
}

