/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.ModBlocks;
import erebus.blocks.BlockDoubleHeightPlant;
import erebus.blocks.BlockLogErebus;
import erebus.blocks.BlockSmallPlant;
import erebus.blocks.EnumWood;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenRottenAcacia;
import erebus.world.feature.plant.WorldGenBigLogs;
import erebus.world.feature.plant.WorldGenGiantMushrooms;
import erebus.world.feature.plant.WorldGenMossPatch;
import erebus.world.feature.plant.WorldGenRottenTreeStump;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeDecoratorFungalForest
extends BiomeDecoratorBaseErebus {
    protected final WorldGenerator genMossPatch = new WorldGenMossPatch(0);
    protected final WorldGenerator genLichenPatch = new WorldGenMossPatch(1);
    private final WorldGenBush genMushroomsBrown = new WorldGenBush(Blocks.field_150338_P);
    private final WorldGenBush genMushroomsRed = new WorldGenBush(Blocks.field_150337_Q);
    private final WorldGenBigMushroom genBigMushroomRed = new WorldGenBigMushroom(Blocks.field_150420_aW);
    private final WorldGenBigMushroom genBigMushroomBrown = new WorldGenBigMushroom(Blocks.field_150419_aX);
    private final WorldGenGiantMushrooms genGiantMushrooms = new WorldGenGiantMushrooms();
    private final WorldGenRottenAcacia genRottenAcacia = new WorldGenRottenAcacia();
    public static final Block[] MUSHROOMS = new Block[]{ModBlocks.DUTCH_CAP_MUSHROOM, ModBlocks.KAIZERS_FINGERS_MUSHROOM, ModBlocks.SARCASTIC_CZECH_MUSHROOM, ModBlocks.GRANDMAS_SHOES_MUSHROOM, ModBlocks.DARK_CAPPED_MUSHROOM};

    @Override
    public void decorate() {
        int baseRadius;
        this.attempt = 0;
        while (this.attempt < 10) {
            int length = this.rand.nextInt(5) + 4;
            baseRadius = this.rand.nextInt(3) + 2;
            EnumFacing facing = this.rand.nextBoolean() ? EnumFacing.NORTH : EnumFacing.WEST;
            this.xx = this.x + 16;
            this.yy = this.rand.nextInt(118);
            this.zz = this.z + 16;
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                new WorldGenBigLogs(length, baseRadius, facing, EnumWood.ROTTEN.getLog().func_176223_P().func_177226_a((IProperty)BlockLogErebus.field_176299_a, (Comparable)(facing == EnumFacing.NORTH ? BlockLog.EnumAxis.Z : BlockLog.EnumAxis.X))).func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            int height = this.rand.nextInt(11) + 6;
            baseRadius = this.rand.nextInt(4) + 3;
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(116);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                new WorldGenRottenTreeStump(height, baseRadius).func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 256) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.world.func_180501_a(pos.func_177984_a(), MUSHROOMS[this.rand.nextInt(MUSHROOMS.length)].func_176223_P(), 2);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 400) {
            int r = this.rand.nextInt(100);
            if (r < 16) {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.DUTCH_CAP);
            } else if (r < 25) {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.SARCASTIC_CZECH);
            } else if (r < 80) {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.KAIZERS_FINGERS);
            } else if (r < 96) {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.GRANDMAS_SHOES);
            } else {
                this.genGiantMushrooms.setMushroomType(WorldGenGiantMushrooms.MushroomType.DARK_CAPPED);
            }
            this.xx = this.x + this.offsetXZ();
            this.yy = 25 + this.rand.nextInt(50 + this.rand.nextInt(40));
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            for (int yAttempt = 10; yAttempt > 0 && !this.checkSurface(SurfaceType.GRASS, pos.func_177979_c(yAttempt)); --yAttempt) {
            }
            if (this.checkSurface(SurfaceType.GRASS, pos) && this.genGiantMushrooms.func_180709_b(this.world, this.rand, pos.func_177984_a())) break;
            ++this.attempt;
        }
        this.genMushroomsBrown.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), this.rand.nextInt(120), this.z + this.offsetXZ()));
        this.genMushroomsRed.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), this.rand.nextInt(120), this.z + this.offsetXZ()));
        this.attempt = 0;
        while (this.attempt < 40) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.genBigMushroomRed.func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 40) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.genBigMushroomBrown.func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 100) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos)) {
                    if (this.rand.nextInt(10) == 0 && this.world.func_175623_d(pos.func_177981_b(2))) {
                        ModBlocks.DOUBLE_PLANT.placeAt(this.world, pos.func_177984_a(), BlockDoubleHeightPlant.EnumPlantType.TALL_FERN, 2);
                        break;
                    }
                    if (!this.world.func_175623_d(pos.func_177984_a())) break;
                    this.world.func_180501_a(pos.func_177984_a(), ModBlocks.SMALL_PLANT.func_176223_P().func_177226_a(BlockSmallPlant.PLANT_TYPE, (Comparable)((Object)BlockSmallPlant.EnumSmallPlantType.FERN)), 2);
                    break;
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 20) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos) && this.world.func_175623_d(pos.func_177984_a()) && this.world.func_175623_d(pos.func_177981_b(2))) {
                ModBlocks.DOUBLE_PLANT.placeAt(this.world, pos.func_177984_a(), BlockDoubleHeightPlant.EnumPlantType.TANGLED_STALK_MUSHROOM, 2);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 8) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos) && this.world.func_175623_d(pos.func_177984_a()) && this.world.func_175623_d(pos.func_177981_b(2))) {
                ModBlocks.DOUBLE_PLANT.placeAt(this.world, pos.func_177984_a(), BlockDoubleHeightPlant.EnumPlantType.HIGH_CAPPED_MUSHROOM, 2);
            }
            ++this.attempt;
        }
        if (ConfigHandler.INSTANCE.mossGen) {
            this.attempt = 0;
            while (this.attempt < 10) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 30 + this.rand.nextInt(80);
                this.zz = this.z + this.offsetXZ();
                BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.world.func_175623_d(pos)) {
                    this.genMossPatch.func_180709_b(this.world, this.rand, pos);
                }
                ++this.attempt;
            }
        }
        if (ConfigHandler.INSTANCE.mouldGen) {
            this.attempt = 0;
            while (this.attempt < 10) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 30 + this.rand.nextInt(80);
                this.zz = this.z + this.offsetXZ();
                BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.world.func_175623_d(pos)) {
                    this.genLichenPatch.func_180709_b(this.world, this.rand, pos);
                }
                ++this.attempt;
            }
        }
        this.attempt = 0;
        while (this.attempt < 28) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.MIXED, pos)) {
                this.genRottenAcacia.func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
        if (ConfigHandler.INSTANCE.glowshrooms) {
            this.attempt = 0;
            while (this.attempt < 10) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 30 + this.rand.nextInt(90);
                this.zz = this.z + this.offsetXZ();
                BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.world.func_180495_p(pos).func_177230_c() == ModBlocks.UMBERSTONE && this.world.func_175623_d(pos.func_177977_b())) {
                    this.world.func_180501_a(pos.func_177977_b(), ModBlocks.GLOWSHROOM_STALK_MAIN.func_176223_P(), 2);
                }
                ++this.attempt;
            }
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case COAL: {
                oreGen.setIterations(extraOres ? 2 : 3, extraOres ? 3 : 4).setY(5, 48);
                break;
            }
            case IRON: {
                oreGen.setChance(0.75f).setIterations(extraOres ? 2 : 3, extraOres ? 4 : 5).setY(5, 42);
                break;
            }
            case GOLD: {
                oreGen.setIterations(extraOres ? 2 : 3);
                break;
            }
            case EMERALD: {
                oreGen.setIterations(2, 4).setCheckArea(2);
                break;
            }
            case JADE: {
                oreGen.setIterations(2, 5);
                break;
            }
            case PETRIFIED_WOOD: {
                oreGen.setChance(0.0f);
                break;
            }
            case FOSSIL: {
                oreGen.setChance(0.25f).setOreAmount(5, 8);
            }
        }
    }
}

