/*
 * Decompiled with CFR 0.152.
 */
package goki.stats;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import goki.stats.GokiStats;
import goki.stats.handlers.PacketStatAlter;
import goki.stats.handlers.PacketSyncStatConfig;
import goki.stats.lib.Helper;
import goki.stats.lib.IDMDTuple;
import goki.stats.stats.Stat;
import goki.stats.stats.StatMiningMagician;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

public class Events {
    @SubscribeEvent
    public void harvestBlock(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.harvester;
        if (player != null) {
            if (Helper.getPlayerStatLevel(player, Stat.STAT_TREASURE_FINDER) > 0) {
                boolean treasureFound = false;
                Random random = player.func_70681_au();
                List<ItemStack> items = Stat.STAT_TREASURE_FINDER.getApplicableItemStackList(event.block, event.blockMetadata, Helper.getPlayerStatLevel(player, Stat.STAT_TREASURE_FINDER));
                List<Integer> chances = Stat.STAT_TREASURE_FINDER.getApplicableChanceList(event.block, event.blockMetadata, Helper.getPlayerStatLevel(player, Stat.STAT_TREASURE_FINDER));
                for (int i = 0; i < items.size(); ++i) {
                    Integer roll = random.nextInt(10000);
                    if (roll > chances.get(i)) continue;
                    if (items.get(i) != null) {
                        event.drops.add(items.get(i));
                        treasureFound = true;
                        continue;
                    }
                    System.out.println("Tried to add an item from Treasure Finder, but it failed!");
                }
                if (treasureFound) {
                    player.field_70170_p.func_72956_a((Entity)player, "gokiStats:treasure", 1.0f, 1.0f);
                }
            }
            if (Helper.getPlayerStatLevel(player, Stat.STAT_MINING_MAGICIAN) > 0) {
                boolean magicHappened = false;
                IDMDTuple mme = new IDMDTuple(event.block, event.blockMetadata);
                if (Stat.STAT_MINING_MAGICIAN.isAffectedByStat(mme) != 0) {
                    block1: for (int i = 0; i < event.drops.size(); ++i) {
                        IDMDTuple entry;
                        if (!(player.func_70681_au().nextDouble() * 100.0 <= (double)Stat.STAT_MINING_MAGICIAN.getBonus(player))) continue;
                        ItemStack item = (ItemStack)event.drops.get(i);
                        if (item.func_77973_b() instanceof ItemBlock && ItemBlock.func_150891_b((Item)((ItemBlock)item.func_77973_b())) == Block.func_149682_b((Block)event.block)) {
                            if (item.func_77960_j() != event.blockMetadata) continue;
                            int randomEntry = player.func_70681_au().nextInt(StatMiningMagician.blockEntries.size());
                            entry = StatMiningMagician.blockEntries.get(randomEntry);
                            ItemStack stack = new ItemStack(Item.func_150899_d((int)entry.id), 1, entry.md);
                            stack.field_77994_a = ((ItemStack)event.drops.get((int)i)).field_77994_a;
                            event.drops.set(i, stack);
                            magicHappened = true;
                            continue;
                        }
                        for (int j = 0; j < StatMiningMagician.itemEntries.size(); ++j) {
                            entry = StatMiningMagician.itemEntries.get(j);
                            if (Item.func_150891_b((Item)item.func_77973_b()) != entry.id || item.func_77960_j() != entry.md) continue;
                            int randomEntry = player.func_70681_au().nextInt(StatMiningMagician.itemEntries.size());
                            IDMDTuple chosenEntry = StatMiningMagician.itemEntries.get(randomEntry);
                            ItemStack stack = new ItemStack(Item.func_150899_d((int)chosenEntry.id), 1, chosenEntry.md);
                            stack.field_77994_a = ((ItemStack)event.drops.get((int)i)).field_77994_a;
                            event.drops.set(i, stack);
                            magicHappened = true;
                            continue block1;
                        }
                    }
                    if (magicHappened) {
                        player.field_70170_p.func_72956_a((Entity)player, "gokiStats:magician", 0.3f, 1.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void playerJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K) {
                GokiStats.packetPipeline.sendTo(new PacketSyncStatConfig(Stat.loseStatsOnDeath, Stat.globalBonusMultiplier, Stat.globalCostMultiplier, Stat.globalLimitMultiplier), (EntityPlayerMP)player);
            } else {
                GokiStats.packetPipeline.sendToServer(new PacketStatAlter(0, 0));
            }
        }
    }

    @SubscribeEvent
    public void playerFall(LivingFallEvent event) {
        EntityPlayer player;
        int featherFallLevel;
        if (event.entity instanceof EntityPlayer && (double)event.distance < 3.0 + (double)(featherFallLevel = Helper.getPlayerStatLevel(player = (EntityPlayer)event.entity, Stat.STAT_FEATHER_FALL)) * 0.1) {
            event.distance = 0.0f;
        }
    }

    @SubscribeEvent
    public void playerDead(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (Stat.loseStatsOnDeath) {
                for (int stat = 0; stat < Stat.totalStats; ++stat) {
                    Helper.setPlayerStatLevel(player, Stat.stats.get(stat), 0);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (event.entity instanceof EntityPlayer && (player = (EntityPlayer)event.entity).func_70051_ag()) {
            player.field_70181_x *= (double)(1.0f + Stat.STAT_LEAPERV.getBonus(player));
            player.field_70159_w *= (double)(1.0f + Stat.STAT_LEAPERH.getBonus(player));
            player.field_70179_y *= (double)(1.0f + Stat.STAT_LEAPERH.getBonus(player));
        }
    }

    @SubscribeEvent
    public void playerBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        EntityPlayer player = event.entityPlayer;
        Block block = event.block;
        int metadata = event.metadata;
        float multiplier = 1.0f + ((float)Stat.STAT_MINING.isAffectedByStat(heldItem, block, metadata) * Stat.STAT_MINING.getBonus(player) + (float)Stat.STAT_DIGGING.isAffectedByStat(heldItem, block, metadata) * Stat.STAT_DIGGING.getBonus(player) + (float)Stat.STAT_CHOPPING.isAffectedByStat(heldItem, block, metadata) * Stat.STAT_CHOPPING.getBonus(player) + (float)Stat.STAT_TRIMMING.isAffectedByStat(heldItem, block, metadata) * Stat.STAT_TRIMMING.getBonus(player));
        event.newSpeed = event.originalSpeed * multiplier;
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        DamageSource source = event.source;
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            float damageMultiplier = 1.0f - (Stat.STAT_PROTECTION.getAppliedBonus(player, source) + Stat.STAT_TOUGH_SKIN.getAppliedBonus(player, source) + Stat.STAT_FEATHER_FALL.getAppliedBonus(player, source) + Stat.STAT_TEMPERING.getAppliedBonus(player, source));
            event.ammount *= damageMultiplier;
        } else if (event.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            ItemStack heldItem = player.func_70694_bm();
            Entity target = event.entity;
            float damage = event.ammount;
            float bonus = 0.0f;
            if (player.func_70694_bm() != null) {
                bonus = Math.round(damage * (Stat.STAT_SWORDSMANSHIP.getAppliedBonus(player, heldItem) + Stat.STAT_BOWMANSHIP.getAppliedBonus(player, heldItem)));
            }
            event.ammount = bonus + damage;
            if (Stat.STAT_REAPER.isAffectedByStat(target) != 0) {
                float reap = Stat.STAT_REAPER.getBonus(player);
                float reapBonus = reap * Stat.STAT_STEALTH.getSecondaryBonus(player) / 100.0f * (float)Stat.STAT_STEALTH.isAffectedByStat(player);
                float reapChance = reap + reapBonus;
                if (player.func_70681_au().nextFloat() <= reapChance) {
                    player.func_71047_c(target);
                    player.field_70170_p.func_72956_a((Entity)player, "gokiStats:reaper", 1.0f, 1.0f);
                    event.ammount = 100000.0f;
                }
            }
        }
    }
}

