/*
 * Decompiled with CFR 0.152.
 */
package goki.stats;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import goki.stats.CommonProxy;
import goki.stats.Events;
import goki.stats.StatsCommand;
import goki.stats.client.gui.GuiHandler;
import goki.stats.handlers.PacketPipeline;
import goki.stats.handlers.PacketStatAlter;
import goki.stats.handlers.PacketStatSync;
import goki.stats.handlers.PacketSyncStatConfig;
import goki.stats.handlers.PacketSyncXP;
import goki.stats.handlers.TickHandler;
import goki.stats.lib.Reference;
import goki.stats.stats.Stat;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="gokiStats", name="gokiStats", version="1.0.0")
public class GokiStats {
    public static final PacketPipeline packetPipeline = new PacketPipeline();
    @Mod.Instance(value="gokiStats")
    public static GokiStats instance;
    @SidedProxy(clientSide="goki.stats.client.ClientProxy", serverSide="goki.stats.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        Reference.configuration = new Configuration(event.getSuggestedConfigurationFile());
        Reference.configuration.load();
        if (!Reference.configuration.get("Version", "Configuration Version", "v1").getString().equals("v1")) {
            System.err.println("gokiStats configuration file has changed! May cause errors! Delete the configuration file and relaunch.");
        }
        Stat.loadOptions(Reference.configuration);
        Stat.loadAllStatsFromConfiguration(Reference.configuration);
        proxy.registerKeybinding();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packetPipeline.initialise();
        packetPipeline.registerPacket(PacketStatSync.class);
        packetPipeline.registerPacket(PacketStatAlter.class);
        packetPipeline.registerPacket(PacketSyncXP.class);
        packetPipeline.registerPacket(PacketSyncStatConfig.class);
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        FMLCommonHandler.instance().bus().register((Object)new TickHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        packetPipeline.postInitialise();
        if (Loader.isModLoaded((String)"PlayerAPI")) {
            Reference.isPlayerAPILoaded = true;
            Stat.STAT_ATHLETICISM.enabled = false;
            Stat.STAT_CLIMBING.enabled = false;
        }
        Stat.saveAllStatsToConfiguration(Reference.configuration);
        Stat.saveGlobalMultipliers(Reference.configuration);
        Reference.configuration.save();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager serverCommand = (ServerCommandManager)command;
        serverCommand.func_71560_a((ICommand)new StatsCommand());
    }
}

