/*
 * Decompiled with CFR 0.152.
 */
package goki.stats.client.gui;

import goki.stats.GokiStats;
import goki.stats.client.gui.GuiStatButton;
import goki.stats.client.gui.GuiStatTooltip;
import goki.stats.handlers.PacketStatAlter;
import goki.stats.lib.Helper;
import goki.stats.stats.Stat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.util.vector.Vector2f;

public class GuiStats
extends GuiScreen {
    private EntityPlayer player = null;
    public static final int STATUS_BUTTON_WIDTH = 24;
    public static final int STATUS_BUTTON_HEIGHT = 24;
    public static float SCALE = 1.0f;
    private static final int HORIZONTAL_SPACING = 8;
    private static final int VERTICAL_SPACING = 12;
    public static final int IMAGE_ROWS = 10;
    private static final int[] COLUMNS = new int[]{4, 3, 5, 3, 5};
    private int currentColumn = 0;
    private int currentRow = 0;
    private GuiStatTooltip toolTip = null;
    private FontRenderer fontRenderer;

    public GuiStats(EntityPlayer player) {
        this.player = player;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        int ttx = 0;
        int tty = 0;
        this.toolTip = null;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, par3);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiStatButton button;
            if (!(this.field_146292_n.get(i) instanceof GuiStatButton) || !(button = (GuiStatButton)((Object)this.field_146292_n.get(i))).isUnderMouse(mouseX, mouseY)) continue;
            this.toolTip = new GuiStatTooltip(Stat.stats.get(i), this.player);
            ttx = button.field_146128_h + 12;
            tty = button.field_146129_i - 1;
            break;
        }
        this.func_73732_a(this.fontRenderer, "Current XP: " + Helper.getXPTotal(this.player.field_71068_ca, this.player.field_71106_cc) + "xp", this.field_146294_l / 2, this.field_146295_m - 16, -1);
        if (this.toolTip != null) {
            this.toolTip.draw(ttx, tty, 0);
        }
    }

    public void func_73866_w_() {
        for (int stat = 0; stat < Stat.totalStats; ++stat) {
            Vector2f pos = this.getButtonPosition(stat);
            this.field_146292_n.add(new GuiStatButton(stat, (int)pos.x, (int)pos.y, 24, 24, Stat.stats.get(stat), this.player));
            ++this.currentColumn;
            if (this.currentColumn >= COLUMNS[this.currentRow]) {
                ++this.currentRow;
                this.currentColumn = 0;
            }
            if (this.currentRow < COLUMNS.length) continue;
            this.currentRow = COLUMNS.length - 1;
        }
    }

    private Vector2f getButtonPosition(int n) {
        Vector2f vec = new Vector2f();
        int columns = COLUMNS[this.currentRow];
        int x = n % columns;
        int y = this.currentRow;
        int rows = COLUMNS.length;
        int amount = columns;
        float width = (float)(amount * 32) * SCALE;
        float height = (float)(rows * 36) * SCALE;
        vec.x = width / (float)amount * (float)x + ((float)this.field_146294_l - width + 8.0f) / 2.0f;
        vec.y = height / (float)rows * (float)y + ((float)this.field_146295_m - height + 12.0f) / 2.0f;
        return vec;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k >= 0 && button.field_146127_k <= Stat.totalStats && button instanceof GuiStatButton) {
            GuiStatButton statButton = (GuiStatButton)button;
            if (!GuiScreen.func_146271_m()) {
                GokiStats.packetPipeline.sendToServer(new PacketStatAlter(Stat.stats.indexOf(statButton.stat), 1));
            } else {
                GokiStats.packetPipeline.sendToServer(new PacketStatAlter(Stat.stats.indexOf(statButton.stat), -1));
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

