/*
 * Decompiled with CFR 0.152.
 */
package goki.stats.lib;

import goki.stats.stats.Stat;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;

public class Helper {
    public static NBTTagCompound getPlayerPersistentNBT(EntityPlayer player) {
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        if (!nbt.func_74764_b("gokiStats_Stats")) {
            nbt.func_74782_a("gokiStats_Stats", (NBTBase)new NBTTagCompound());
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)nbt);
        }
        return nbt;
    }

    public static int getPlayerStatLevel(EntityPlayer player, Stat stat) {
        NBTTagCompound nbt = Helper.getPlayerPersistentNBT(player);
        if (nbt.func_74764_b("gokiStats_Stats")) {
            return ((NBTTagCompound)nbt.func_74781_a("gokiStats_Stats")).func_74771_c(stat.key);
        }
        return 0;
    }

    public static void setPlayerStatLevel(EntityPlayer player, Stat stat, int level) {
        NBTTagCompound nbt = Helper.getPlayerPersistentNBT(player);
        if (nbt.func_74764_b("gokiStats_Stats")) {
            ((NBTTagCompound)nbt.func_74781_a("gokiStats_Stats")).func_74774_a(stat.key, (byte)level);
        }
    }

    public static float trimDecimals(float in, int decimals) {
        float f = (float)((double)in * Math.pow(10.0, decimals));
        int i = (int)f;
        return (float)i / (float)Math.pow(10.0, decimals);
    }

    public static void setPlayersExpTo(EntityPlayer player, int total) {
        player.field_71068_ca = Helper.getLevelFromXPValue(total);
        player.field_71106_cc = Helper.getCurrentFromXPValue(total);
    }

    public static int getXPTotal(int xpLevel, float current) {
        return (int)((float)Helper.getXPValueFromLevel(xpLevel) + (float)Helper.getXPValueToNextLevel(xpLevel) * current);
    }

    public static int getXPTotal(EntityPlayer player) {
        return (int)((float)Helper.getXPValueFromLevel(player.field_71068_ca) + (float)Helper.getXPValueToNextLevel(player.field_71068_ca) * player.field_71106_cc);
    }

    public static int getLevelFromXPValue(int value) {
        int level = 0;
        level = value >= Helper.getXPValueFromLevel(30) ? (int)(0.07142857142857142 * (Math.sqrt(56.0 * (double)value - 32511.0) + 303.0)) : (value >= Helper.getXPValueFromLevel(15) ? (int)(0.16666666666666666 * (Math.sqrt(24.0 * (double)value - 5159.0) + 59.0)) : (int)((double)value / 17.0));
        return level;
    }

    public static float getCurrentFromXPValue(int value) {
        if (value == 0) {
            return 0.0f;
        }
        int level = Helper.getLevelFromXPValue(value);
        int needed = Helper.getXPValueFromLevel(level);
        int next = Helper.getXPValueToNextLevel(level);
        int difference = value - needed;
        float current = (float)difference / (float)next;
        return current;
    }

    public static int getXPValueFromLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? (int)(3.5 * Math.pow(xpLevel, 2.0) - 151.5 * (double)xpLevel + 2220.0) : (xpLevel >= 15 ? (int)(1.5 * Math.pow(xpLevel, 2.0) - 29.5 * (double)xpLevel + 360.0) : 17 * xpLevel);
        return val;
    }

    public static int getXPValueToNextLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? 7 * xpLevel - 148 : (xpLevel >= 15 ? 3 * xpLevel - 28 : 17);
        return val;
    }

    public static float getDamageDealt(EntityPlayer player, Entity target, DamageSource source) {
        float damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float bonusDamage = 0.0f;
        boolean targetIsLiving = target instanceof EntityLivingBase;
        boolean critical = false;
        if (targetIsLiving) {
            bonusDamage = EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)target));
        }
        if (damage > 0.0f || bonusDamage > 0.0f) {
            boolean bl = critical = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && targetIsLiving;
            if (critical && damage > 0.0f) {
                damage *= 1.5f;
            }
            damage += bonusDamage;
        }
        return damage;
    }

    public static float getFallResistance(EntityLivingBase entity) {
        float resistance = 3.0f;
        PotionEffect potioneffect = entity.func_70660_b(Potion.field_76430_j);
        float bonus = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        return resistance + bonus;
    }
}

