/*
 * Decompiled with CFR 0.152.
 */
package goki.stats.stats;

import goki.stats.lib.Helper;
import goki.stats.lib.IDMDTuple;
import goki.stats.stats.Stat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

public class StatMiningMagician
extends Stat {
    public static List<IDMDTuple> blockEntries = new ArrayList<IDMDTuple>();
    private static IDMDTuple[] defaultBlockEntries = new IDMDTuple[]{new IDMDTuple(Blocks.field_150365_q, 0), new IDMDTuple(Blocks.field_150482_ag, 0), new IDMDTuple(Blocks.field_150412_bA, 0), new IDMDTuple(Blocks.field_150352_o, 0), new IDMDTuple(Blocks.field_150366_p, 0), new IDMDTuple(Blocks.field_150369_x, 0), new IDMDTuple(Blocks.field_150449_bY, 0), new IDMDTuple(Blocks.field_150450_ax, 0)};
    public static List<IDMDTuple> itemEntries = new ArrayList<IDMDTuple>();
    private static IDMDTuple[] defaultItemEntries = new IDMDTuple[]{new IDMDTuple(Items.field_151044_h, 0), new IDMDTuple(Items.field_151045_i, 0), new IDMDTuple(Items.field_151166_bC, 0), new IDMDTuple(Items.field_151043_k, 0), new IDMDTuple(Items.field_151042_j, 0), new IDMDTuple(Items.field_151100_aR, 4), new IDMDTuple(Items.field_151128_bU, 0), new IDMDTuple(Items.field_151137_ax, 0)};

    public StatMiningMagician(int id, String key, String name, int limit) {
        super(id, key, name, limit);
        for (IDMDTuple mme : defaultBlockEntries) {
            blockEntries.add(mme);
        }
        for (IDMDTuple mme : defaultItemEntries) {
            itemEntries.add(mme);
        }
    }

    @Override
    public float getBonus(int level) {
        return StatMiningMagician.getFinalBonus((float)level * 0.3f);
    }

    @Override
    public String getAppliedDescriptionString(EntityPlayer player) {
        return Helper.trimDecimals(this.getBonus(player), 1) + "% chance to transform an ore when harvesting.";
    }

    @Override
    public int isAffectedByStat(Object object) {
        if (object instanceof IDMDTuple) {
            IDMDTuple idmd = (IDMDTuple)object;
            for (IDMDTuple entry : blockEntries) {
                if (!idmd.equals(entry)) continue;
                return 1;
            }
            for (IDMDTuple entry : itemEntries) {
                if (!idmd.equals(entry)) continue;
                return 1;
            }
        }
        return super.isAffectedByStat(object);
    }
}

