/*
 * Decompiled with CFR 0.152.
 */
package goki.stats.stats;

import goki.stats.lib.TreasureFinderEntry;
import goki.stats.stats.Stat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class StatTreasureFinder
extends Stat {
    public static List<TreasureFinderEntry> entries = new ArrayList<TreasureFinderEntry>();
    public static String[] defaultEntries = new String[]{new TreasureFinderEntry(Blocks.field_150354_m, 0, Items.field_151074_bl, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151078_bh, 0, 1, 40).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151103_aS, 0, 1, 20).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151070_bp, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151016_H, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151123_aH, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150354_m, 0, Items.field_151069_bo, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150354_m, 0, Items.field_151113_aN, 0, 1, 5).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150354_m, 0, Items.field_151111_aL, 0, 1, 5).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150354_m, 0, Items.field_151119_aD, 0, 1, 20).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151054_z, 0, 1, 6).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151174_bG, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151172_bF, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151034_e, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry((Block)Blocks.field_150362_t, 0, Items.field_151034_e, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry((Block)Blocks.field_150361_u, 0, Items.field_151034_e, 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150337_Q), 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150338_P), 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150328_O), 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150327_N), 0, 1, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151055_y, 0, 1, 100).toConfigurationString(), new TreasureFinderEntry((Block)Blocks.field_150329_H, 0, Items.field_151080_bb, 0, 1, 30).toConfigurationString(), new TreasureFinderEntry((Block)Blocks.field_150329_H, 0, Items.field_151081_bc, 0, 1, 30).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151082_bd, 0, 2, 50).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151147_al, 0, 2, 50).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151076_bf, 0, 2, 50).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150354_m, 0, Items.field_151042_j, 0, 2, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150354_m, 0, Items.field_151043_k, 0, 2, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151116_aA, 0, 2, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151008_G, 0, 2, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150325_L), 0, 2, 10).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150354_m, 0, Items.field_151137_ax, 0, 2, 50).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151133_ar, 0, 3, 20).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151086_cn, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151096_cd, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151094_cf, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151093_ce, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151091_cg, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151092_ch, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151089_ci, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151090_cj, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151087_ck, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151088_cl, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151084_co, 0, 3, 2).toConfigurationString(), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151085_cm, 0, 3, 2).toConfigurationString()};

    public StatTreasureFinder(int id, String key, String name, int limit) {
        super(id, key, name, limit);
    }

    @Override
    public String getAppliedDescriptionString(EntityPlayer player) {
        if (this.getPlayerStatLevel(player) == 0) {
            return "Chance to find additional items when harvesting blocks.";
        }
        return "Chance to find more rare additional items when harvesting blocks.";
    }

    @Override
    public void loadFromConfigurationFile(Configuration config) {
        entries.clear();
        String[] entryStrings = config.get("Treasure Finder", "Entries", defaultEntries).getStringList();
        for (int i = 0; i < entryStrings.length; ++i) {
            entries.add(new TreasureFinderEntry(entryStrings[i]));
        }
    }

    @Override
    public void saveToConfigurationFile(Configuration config) {
        String[] entryStrings = new String[entries.size()];
        for (int i = 0; i < entryStrings.length; ++i) {
            entryStrings[i] = entries.get(i).toConfigurationString();
        }
        config.get("Treasure Finder", "Entries", defaultEntries).set(entryStrings);
    }

    public List<ItemStack> getApplicableItemStackList(Block block, int blockMD, int level) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (TreasureFinderEntry tfe : entries) {
            if (tfe.miniumLevel > level || (tfe.block != null || block != Blocks.field_150346_d && block != Blocks.field_150349_c) && (tfe.block != block || tfe.blockMD != blockMD)) continue;
            items.add(new ItemStack(tfe.item, 1, tfe.itemMD));
        }
        return items;
    }

    public List<Integer> getApplicableChanceList(Block block, int blockMD, int level) {
        ArrayList<Integer> chance = new ArrayList<Integer>();
        for (TreasureFinderEntry tfe : entries) {
            if (tfe.miniumLevel > level || (tfe.block != null || block != Blocks.field_150346_d && block != Blocks.field_150349_c) && (tfe.block != block || tfe.blockMD != blockMD)) continue;
            chance.add(tfe.chance);
        }
        return chance;
    }

    @Override
    public String toConfigurationString() {
        String configString = "";
        for (int i = 0; i < entries.size(); ++i) {
            configString = configString + "," + entries.get(i).toConfigurationString();
        }
        return configString;
    }

    @Override
    public void fromConfigurationString(String configString) {
        entries.clear();
        String[] configStringSplit = configString.split(",");
        for (int i = 0; i < configStringSplit.length; ++i) {
            entries.add(new TreasureFinderEntry(configStringSplit[i]));
        }
    }

    @Override
    public int getCost(int level) {
        int cost = 170;
        if (level == 1) {
            cost = 370;
        } else if (level == 2) {
            cost = 820;
        }
        return cost;
    }

    @Override
    public int getLimit() {
        return 3;
    }
}

