/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.renderer;

import li.cil.scannable.common.init.Items;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public enum OverlayRenderer {
    INSTANCE;

    private static final ResourceLocation PROGRESS;

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack stack = player.func_184607_cu();
        if (stack.func_190926_b()) {
            return;
        }
        if (!Items.isScanner(stack)) {
            return;
        }
        int total = stack.func_77988_m();
        int remaining = player.func_184605_cv();
        float progress = MathHelper.func_76131_a((float)(1.0f - ((float)remaining - event.getPartialTicks()) / (float)total), (float)0.0f, (float)1.0f);
        ScaledResolution resolution = event.getResolution();
        int screenWidth = resolution.func_78326_a();
        int screenHeight = resolution.func_78328_b();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)0.66f, (float)0.8f, (float)0.93f, (float)0.66f);
        mc.func_110434_K().func_110577_a(PROGRESS);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(4, DefaultVertexFormats.field_181707_g);
        int width = 64;
        int height = 64;
        int midX = screenWidth / 2;
        int midY = screenHeight / 2;
        int left = midX - 32;
        int right = midX + 32;
        int top = midY - 32;
        int bottom = midY + 32;
        float angle = (float)((double)progress * Math.PI * 2.0);
        float tx = MathHelper.func_76126_a((float)angle);
        float ty = MathHelper.func_76134_b((float)angle);
        buffer.func_181662_b((double)midX, (double)top, 0.0).func_187315_a(0.5, 1.0).func_181675_d();
        if ((double)progress < 0.125) {
            buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
            float x = tx / ty * 0.5f;
            buffer.func_181662_b((double)((float)midX + x * 64.0f), (double)top, 0.0).func_187315_a(0.5 + (double)x, 1.0).func_181675_d();
        } else {
            buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
            buffer.func_181662_b((double)right, (double)top, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)right, (double)top, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            if ((double)progress < 0.375) {
                buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
                float y = Math.abs(ty / tx - 1.0f) * 0.5f;
                buffer.func_181662_b((double)right, (double)((float)top + y * 64.0f), 0.0).func_187315_a(1.0, (double)(1.0f - y)).func_181675_d();
            } else {
                buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
                buffer.func_181662_b((double)right, (double)bottom, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                buffer.func_181662_b((double)right, (double)bottom, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                if ((double)progress < 0.625) {
                    buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
                    float x = Math.abs(tx / ty - 1.0f) * 0.5f;
                    buffer.func_181662_b((double)((float)left + x * 64.0f), (double)bottom, 0.0).func_187315_a((double)x, 0.0).func_181675_d();
                } else {
                    buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
                    buffer.func_181662_b((double)left, (double)bottom, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b((double)left, (double)bottom, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                    if ((double)progress < 0.875) {
                        buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
                        float y = (ty / tx + 1.0f) * 0.5f;
                        buffer.func_181662_b((double)left, (double)((float)top + y * 64.0f), 0.0).func_187315_a(0.0, (double)(1.0f - y)).func_181675_d();
                    } else {
                        buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
                        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                        if (progress < 1.0f) {
                            buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
                            float x = Math.abs(tx / ty) * 0.5f;
                            buffer.func_181662_b((double)((float)midX - x * 64.0f), (double)top, 0.0).func_187315_a(0.5 - (double)x, 1.0).func_181675_d();
                        } else {
                            buffer.func_181662_b((double)midX, (double)midY, 0.0).func_187315_a(0.5, 0.5).func_181675_d();
                            buffer.func_181662_b((double)midX, (double)top, 0.0).func_187315_a(0.5, 1.0).func_181675_d();
                        }
                    }
                }
            }
        }
        tessellator.func_78381_a();
        mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"gui.scannable.scanner.progress", (Object[])new Object[]{MathHelper.func_76141_d((float)(progress * 100.0f))}), (float)(right + 12), (float)(midY - mc.field_71466_p.field_78288_b / 2), -861221650, true);
        GlStateManager.func_179144_i((int)0);
    }

    static {
        PROGRESS = new ResourceLocation("scannable", "textures/gui/overlay/scanner_progress.png");
    }
}

