/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class MessageStructureRequest
implements IMessage {
    private int dimension;
    private BlockPos center;
    private float radius;
    private boolean hideExplored;

    public MessageStructureRequest(World world, BlockPos center, float radius, boolean hideExplored) {
        this.dimension = world.field_73011_w.getDimension();
        this.center = center;
        this.radius = radius;
        this.hideExplored = hideExplored;
    }

    public MessageStructureRequest() {
    }

    public int getDimension() {
        return this.dimension;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean hideExplored() {
        return this.hideExplored;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.dimension = packet.readInt();
        this.center = packet.func_179259_c();
        this.radius = packet.readFloat();
        this.hideExplored = packet.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.writeInt(this.dimension);
        packet.func_179255_a(this.center);
        packet.writeFloat(this.radius);
        packet.writeBoolean(this.hideExplored);
    }
}

