/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.renderer.ScannerRenderer;
import li.cil.scannable.common.capabilities.CapabilityScannerModule;
import li.cil.scannable.common.config.Settings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public enum ScanManager {
    INSTANCE;

    private final Set<ScanResultProvider> collectingProviders = new HashSet<ScanResultProvider>();
    private final Map<ScanResultProvider, List<ScanResult>> collectingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private final Map<ScanResultProvider, List<ScanResult>> pendingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private final Map<ScanResultProvider, List<ScanResult>> renderingResults = new HashMap<ScanResultProvider, List<ScanResult>>();
    private final List<ScanResult> renderingList = new ArrayList<ScanResult>();
    private int scanningTicks = -1;
    private long currentStart = -1L;
    @Nullable
    private Vec3d lastScanCenter;
    private MatrixStack viewMatrix;
    private Matrix4f projectionMatrix;

    private static float computeTargetRadius() {
        return Minecraft.func_71410_x().field_71460_t.func_205001_m();
    }

    public static int computeScanGrowthDuration() {
        return 2000 * Minecraft.func_71410_x().field_71474_y.field_151451_c / 12;
    }

    public static float computeRadius(long start, float duration) {
        float r1 = ScanManager.computeTargetRadius();
        float t1 = duration;
        float b = 200.0f;
        float n = 1.0f / ((t1 + 200.0f) * (t1 + 200.0f) - 40000.0f);
        float a = -r1 * 200.0f * 200.0f * n;
        float c = r1 * n;
        float t = System.currentTimeMillis() - start;
        return 10.0f + a + (t + 200.0f) * (t + 200.0f) * c;
    }

    public void beginScan(PlayerEntity player, List<ItemStack> stacks) {
        this.cancelScan();
        float scanRadius = Settings.baseScanRadius;
        ArrayList modules = new ArrayList();
        for (ItemStack stack : stacks) {
            LazyOptional module = stack.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
            module.ifPresent(modules::add);
        }
        for (ScannerModule module : modules) {
            ScanResultProvider provider = module.getResultProvider();
            if (provider != null) {
                this.collectingProviders.add(provider);
            }
            scanRadius = module.adjustGlobalRange(scanRadius);
        }
        if (this.collectingProviders.isEmpty()) {
            return;
        }
        Vec3d center = player.func_174791_d();
        for (ScanResultProvider provider : this.collectingProviders) {
            provider.initialize(player, stacks, center, scanRadius, 40);
        }
    }

    public void updateScan(Entity entity, boolean finish) {
        int remaining = 40 - this.scanningTicks;
        if (!finish) {
            if (remaining <= 0) {
                return;
            }
            for (ScanResultProvider scanResultProvider : this.collectingProviders) {
                scanResultProvider.computeScanResults(result -> this.collectingResults.computeIfAbsent(provider, p -> new ArrayList()).add(result));
            }
            ++this.scanningTicks;
            return;
        }
        for (int i = 0; i < remaining; ++i) {
            for (ScanResultProvider provider : this.collectingProviders) {
                provider.computeScanResults(result -> this.collectingResults.computeIfAbsent(provider, p -> new ArrayList()).add(result));
            }
        }
        for (ScanResultProvider scanResultProvider : this.collectingProviders) {
            scanResultProvider.reset();
        }
        this.clear();
        this.lastScanCenter = entity.func_174791_d();
        this.currentStart = System.currentTimeMillis();
        this.pendingResults.putAll(this.collectingResults);
        this.pendingResults.values().forEach(list -> list.sort(Comparator.comparing(result -> -this.lastScanCenter.func_72438_d(result.getPosition()))));
        ScannerRenderer.INSTANCE.ping(this.lastScanCenter);
        this.cancelScan();
    }

    public void cancelScan() {
        this.collectingProviders.clear();
        this.collectingResults.clear();
        this.scanningTicks = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        if (this.lastScanCenter == null || this.currentStart < 0L) {
            return;
        }
        if (10000 < (int)(System.currentTimeMillis() - this.currentStart)) {
            this.pendingResults.clear();
            Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
            synchronized (map) {
                if (!this.renderingResults.isEmpty()) {
                    Iterator<Map.Entry<ScanResultProvider, List<ScanResult>>> iterator = this.renderingResults.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<ScanResultProvider, List<ScanResult>> entry = iterator.next();
                        List<ScanResult> list = entry.getValue();
                        for (int i = MathHelper.func_76123_f((float)((float)list.size() / 2.0f)); i > 0; --i) {
                            list.remove(list.size() - 1);
                        }
                        if (!list.isEmpty()) continue;
                        iterator.remove();
                    }
                }
                if (this.renderingResults.isEmpty()) {
                    this.clear();
                }
            }
            return;
        }
        if (this.pendingResults.size() <= 0) {
            return;
        }
        float radius = ScanManager.computeRadius(this.currentStart, ScanManager.computeScanGrowthDuration());
        float sqRadius = radius * radius;
        Iterator<Map.Entry<ScanResultProvider, List<ScanResult>>> iterator = this.pendingResults.entrySet().iterator();
        while (iterator.hasNext()) {
            ScanResult result;
            Vec3d position;
            Map.Entry<ScanResultProvider, List<ScanResult>> entry = iterator.next();
            ScanResultProvider provider = entry.getKey();
            List<ScanResult> results = entry.getValue();
            while (results.size() > 0 && this.lastScanCenter.func_72436_e(position = (result = results.get(results.size() - 1)).getPosition()) <= (double)sqRadius) {
                results.remove(results.size() - 1);
                if (!provider.bakeResult((IBlockReader)world, result)) continue;
                Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
                synchronized (map) {
                    this.renderingResults.computeIfAbsent(provider, p -> new ArrayList()).add(result);
                }
            }
            if (results.size() != 0) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
        synchronized (map) {
            if (this.renderingResults.isEmpty()) {
                return;
            }
            this.viewMatrix = new MatrixStack();
            this.viewMatrix.func_227866_c_().func_227870_a_().set(event.getMatrixStack().func_227866_c_().func_227870_a_());
            this.projectionMatrix = event.getProjectionMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
        synchronized (map) {
            if (this.renderingResults.isEmpty()) {
                return;
            }
            RenderSystem.matrixMode((int)5889);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.multMatrix((Matrix4f)this.projectionMatrix);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            this.render(event.getPartialTicks(), this.viewMatrix, this.projectionMatrix);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.popMatrix();
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
        }
    }

    private void render(float partialTicks, MatrixStack matrixStack, Matrix4f projectionMatrix) {
        ActiveRenderInfo activeRenderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d pos = activeRenderInfo.func_216785_c();
        ClippingHelperImpl frustum = new ClippingHelperImpl(matrixStack.func_227866_c_().func_227870_a_(), projectionMatrix);
        frustum.func_228952_a_(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        RenderSystem.disableDepthTest();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-pos.field_72450_a, -pos.field_72448_b, -pos.field_72449_c);
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        for (Map.Entry<ScanResultProvider, List<ScanResult>> entry : this.renderingResults.entrySet()) {
            for (ScanResult result : entry.getValue()) {
                AxisAlignedBB bounds = result.getRenderBounds();
                if (bounds != null && !frustum.func_228957_a_(bounds)) continue;
                this.renderingList.add(result);
            }
            if (this.renderingList.isEmpty()) continue;
            entry.getKey().render((IRenderTypeBuffer)renderTypeBuffer, matrixStack, projectionMatrix, activeRenderInfo, partialTicks, this.renderingList);
            this.renderingList.clear();
        }
        renderTypeBuffer.func_228461_a_();
        matrixStack.func_227865_b_();
        RenderSystem.enableDepthTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        this.pendingResults.clear();
        Map<ScanResultProvider, List<ScanResult>> map = this.renderingResults;
        synchronized (map) {
            this.renderingResults.forEach((provider, results) -> provider.reset());
            this.renderingResults.clear();
        }
        this.lastScanCenter = null;
        this.currentStart = -1L;
    }
}

