/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.shader.ScanEffectShader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.FramebufferConstants;
import net.minecraft.client.util.JSONBlendingMode;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public enum ScannerRenderer {
    INSTANCE;

    private int depthCopyFbo;
    private int depthCopyColorBuffer;
    private int depthCopyDepthBuffer;
    private static final JSONBlendingMode RESET_BLEND_STATE;
    private long currentStart;

    public void ping(Vec3d pos) {
        this.currentStart = System.currentTimeMillis();
        ScanEffectShader.INSTANCE.setCenter(pos);
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        boolean shouldRender;
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        boolean bl = shouldRender = this.currentStart > 0L && adjustedDuration > (int)(System.currentTimeMillis() - this.currentStart);
        if (shouldRender) {
            if (this.depthCopyFbo == 0) {
                this.createDepthCopyFramebuffer();
            }
            this.render(event.getMatrixStack().func_227866_c_().func_227870_a_(), event.getProjectionMatrix());
        } else {
            if (this.depthCopyFbo != 0) {
                this.deleteDepthCopyFramebuffer();
            }
            this.currentStart = 0L;
        }
    }

    private void render(Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer framebuffer = mc.func_147110_a();
        this.updateDepthTexture(framebuffer);
        Matrix4f invertedViewMatrix = new Matrix4f(viewMatrix);
        invertedViewMatrix.func_226600_c_();
        ScanEffectShader.INSTANCE.setInverseViewMatrix(invertedViewMatrix);
        Matrix4f invertedProjectionMatrix = new Matrix4f(projectionMatrix);
        invertedProjectionMatrix.func_226600_c_();
        ScanEffectShader.INSTANCE.setInverseProjectionMatrix(invertedProjectionMatrix);
        Vec3d position = mc.field_71460_t.func_215316_n().func_216785_c();
        ScanEffectShader.INSTANCE.setPosition(position);
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        float radius = ScanManager.computeRadius(this.currentStart, adjustedDuration);
        ScanEffectShader.INSTANCE.setRadius(radius);
        RESET_BLEND_STATE.func_148109_a();
        ScanEffectShader.INSTANCE.bind();
        this.blit(framebuffer);
        ScanEffectShader.INSTANCE.unbind();
    }

    private void updateDepthTexture(Framebuffer framebuffer) {
        GlStateManager.func_227727_h_((int)36008, (int)framebuffer.field_147616_f);
        GlStateManager.func_227727_h_((int)36009, (int)this.depthCopyFbo);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)framebuffer.field_147622_a, (int)framebuffer.field_147620_b, (int)0, (int)0, (int)framebuffer.field_147622_a, (int)framebuffer.field_147620_b, (int)256, (int)9728);
    }

    private void createDepthCopyFramebuffer() {
        Framebuffer framebuffer = Minecraft.func_71410_x().func_147110_a();
        this.depthCopyFbo = GlStateManager.func_227749_p_();
        this.depthCopyColorBuffer = this.createTexture(framebuffer.field_147622_a, framebuffer.field_147620_b, 32856, 6408, 5121);
        this.depthCopyDepthBuffer = this.createTexture(framebuffer.field_147622_a, framebuffer.field_147620_b, 6402, 6402, 5126);
        GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)this.depthCopyFbo);
        GlStateManager.func_227645_a_((int)FramebufferConstants.field_227592_a_, (int)FramebufferConstants.field_227594_c_, (int)3553, (int)this.depthCopyColorBuffer, (int)0);
        GlStateManager.func_227645_a_((int)FramebufferConstants.field_227592_a_, (int)FramebufferConstants.field_227595_d_, (int)3553, (int)this.depthCopyDepthBuffer, (int)0);
        GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)0);
        ScanEffectShader.INSTANCE.setDepthBuffer(this.depthCopyDepthBuffer);
    }

    private void deleteDepthCopyFramebuffer() {
        ScanEffectShader.INSTANCE.setDepthBuffer(0);
        GlStateManager.func_227738_l_((int)this.depthCopyFbo);
        this.depthCopyFbo = 0;
        TextureUtil.func_225679_a_((int)this.depthCopyColorBuffer);
        this.depthCopyColorBuffer = 0;
        TextureUtil.func_225679_a_((int)this.depthCopyDepthBuffer);
        this.depthCopyDepthBuffer = 0;
    }

    private int createTexture(int width, int height, int internalFormat, int format, int type) {
        int texture = TextureUtil.func_225678_a_();
        GlStateManager.func_227760_t_((int)texture);
        GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10497);
        GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10497);
        GlStateManager.func_227677_b_((int)3553, (int)10241, (int)9728);
        GlStateManager.func_227677_b_((int)3553, (int)10240, (int)9728);
        GlStateManager.func_227677_b_((int)3553, (int)34891, (int)6409);
        GlStateManager.func_227677_b_((int)3553, (int)34892, (int)0);
        GlStateManager.func_227677_b_((int)3553, (int)34893, (int)515);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)type, null);
        GlStateManager.func_227760_t_((int)0);
        return texture;
    }

    private void blit(Framebuffer framebuffer) {
        int width = framebuffer.field_147622_a;
        int height = framebuffer.field_147620_b;
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        this.setupMatrices(width, height);
        framebuffer.func_147610_a(false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(0.0, (double)height, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)width, (double)height, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)width, 0.0, 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        this.restoreMatrices();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    private void setupMatrices(int width, int height) {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.translated((double)0.0, (double)0.0, (double)-2000.0);
        RenderSystem.viewport((int)0, (int)0, (int)width, (int)height);
    }

    private void restoreMatrices() {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
    }

    static {
        RESET_BLEND_STATE = new JSONBlendingMode();
    }
}

