/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import li.cil.scannable.api.API;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.ScanFilterBlock;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScannerModuleBlock;
import li.cil.scannable.client.shader.ScanResultShader;
import li.cil.scannable.common.capabilities.CapabilityScannerModule;
import li.cil.scannable.common.config.Settings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public final class ScanResultProviderBlock
extends AbstractScanResultProvider {
    public static final ScanResultProviderBlock INSTANCE = new ScanResultProviderBlock();
    private static final float MAX_ALPHA = 0.66f;
    private static final float MIN_ALPHA = 0.2f;
    private final IntObjectMap<List<ScanFilterBlock>> scanFilters = new IntObjectHashMap();
    private final IntList scanFilterKeys = new IntArrayList();
    private BlockPos min;
    private BlockPos max;
    private int blocksPerTick;
    private int x;
    private int y;
    private int z;
    private final Map<BlockPos, BlockScanResult> resultClusters = new HashMap<BlockPos, BlockScanResult>();

    @Override
    public void initialize(PlayerEntity player, Collection<ItemStack> modules, Vec3d center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius, scanTicks);
        this.scanFilters.clear();
        for (ItemStack module : modules) {
            LazyOptional capability = module.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
            capability.filter(c -> c instanceof ScannerModuleBlock).ifPresent(c -> {
                ScannerModuleBlock m = (ScannerModuleBlock)c;
                Optional<ScanFilterBlock> filter = m.getFilter(module);
                filter.ifPresent(f -> {
                    int localRadius = (int)Math.ceil(m.adjustLocalRange(this.radius));
                    ((List)this.scanFilters.computeIfAbsent((Object)localRadius, r -> new ArrayList())).add(f);
                });
            });
        }
        this.scanFilterKeys.clear();
        this.scanFilterKeys.addAll((Collection)this.scanFilters.keySet());
        this.scanFilterKeys.sort((a, b) -> -Integer.compare(a, b));
        if (this.scanFilterKeys.size() > 0) {
            this.radius = this.scanFilterKeys.getInt(0);
            this.min = new BlockPos(center).func_177963_a((double)(-this.radius), (double)(-this.radius), (double)(-this.radius));
            this.max = new BlockPos(center).func_177963_a((double)this.radius, (double)this.radius, (double)this.radius);
            this.x = this.min.func_177958_n();
            this.y = this.min.func_177956_o() - 1;
            this.z = this.min.func_177952_p();
            BlockPos size = this.max.func_177973_b((Vec3i)this.min);
            int count = (size.func_177958_n() + 1) * (size.func_177956_o() + 1) * (size.func_177952_p() + 1);
            this.blocksPerTick = MathHelper.func_76123_f((float)((float)count / (float)scanTicks));
        }
    }

    @Override
    public void computeScanResults(Consumer<ScanResult> callback) {
        World world = this.player.func_130014_f_();
        block0: for (int i = 0; i < this.blocksPerTick; ++i) {
            BlockPos pos;
            BlockState state;
            if (!this.moveNext(world)) {
                Minecraft.func_71410_x().func_213239_aq().func_76319_b();
                return;
            }
            if (this.center.func_186679_c((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > (double)(this.radius * this.radius) || Settings.shouldIgnore((state = world.func_180495_p(pos = new BlockPos(this.x, this.y, this.z))).func_177230_c())) continue;
            int stateId = Block.func_196246_j((BlockState)state);
            IntListIterator intListIterator = this.scanFilterKeys.iterator();
            while (intListIterator.hasNext()) {
                int filterRadius = (Integer)intListIterator.next();
                if (this.center.func_186679_c((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > (double)(filterRadius * filterRadius)) continue block0;
                if (!((List)this.scanFilters.get(filterRadius)).stream().anyMatch(f -> f.matches(state)) || this.tryAddToCluster(pos, stateId)) continue;
                BlockScanResult result = new BlockScanResult(stateId, pos);
                callback.accept(result);
                this.resultClusters.put(pos, result);
                continue block0;
            }
        }
    }

    @Override
    public boolean bakeResult(IBlockReader world, ScanResult result) {
        BlockScanResult blockResult = (BlockScanResult)result;
        if (blockResult.isRoot()) {
            blockResult.computeColor(world);
            return true;
        }
        return false;
    }

    @Override
    public void render(IRenderTypeBuffer renderTypeBuffer, MatrixStack matrixStack, Matrix4f projectionMatrix, ActiveRenderInfo renderInfo, float partialTicks, List<ScanResult> results) {
        Vec3d lookVec = new Vec3d(renderInfo.func_227996_l_());
        Vec3d viewerEyes = renderInfo.func_216785_c();
        float colorNormalizer = 0.003921569f;
        if (Minecraft.func_71410_x().field_71460_t.field_175074_C) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            matrixStack.func_227860_a_();
            Minecraft.func_71410_x().field_71460_t.func_228381_a_(matrixStack, renderInfo, partialTicks);
            matrixStack.func_227865_b_();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        ScanResultShader.setProjectionMatrix(projectionMatrix);
        IVertexBuilder buffer = renderTypeBuffer.getBuffer(ScanResultProviderBlock.getBlockScanResultRenderLayer());
        for (ScanResult result2 : results) {
            BlockScanResult blockResult = (BlockScanResult)result2;
            Vec3d toResult = blockResult.getPosition().func_178788_d(viewerEyes);
            float lookDirDot = (float)lookVec.func_72430_b(toResult.func_72432_b());
            float sqLookDirDot = lookDirDot * lookDirDot;
            float sq2LookDirDot = sqLookDirDot * sqLookDirDot;
            float focusScale = MathHelper.func_76131_a((float)(sq2LookDirDot * sq2LookDirDot + 0.005f), (float)0.5f, (float)1.0f);
            int color = blockResult.getColor();
            float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
            float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
            float b = (float)(color & 0xFF) * 0.003921569f;
            float a = Math.max(0.2f, 0.66f * focusScale);
            ScanResultProviderBlock.drawCube(buffer, matrixStack.func_227866_c_().func_227870_a_(), (float)((BlockScanResult)blockResult).bounds.field_72340_a, (float)((BlockScanResult)blockResult).bounds.field_72338_b, (float)((BlockScanResult)blockResult).bounds.field_72339_c, (float)((BlockScanResult)blockResult).bounds.field_72336_d, (float)((BlockScanResult)blockResult).bounds.field_72337_e, (float)((BlockScanResult)blockResult).bounds.field_72334_f, r, g, b, a);
        }
        float yaw = renderInfo.func_216778_f();
        float pitch = renderInfo.func_216777_e();
        boolean showDistance = renderInfo.func_216773_g().func_225608_bj_();
        results.sort(Comparator.comparing(result -> {
            BlockScanResult blockResult = (BlockScanResult)result;
            Vec3d resultPos = blockResult.getPosition();
            Vec3d toResult = resultPos.func_178788_d(viewerEyes);
            return lookVec.func_72430_b(toResult.func_72432_b());
        }));
        for (ScanResult result3 : results) {
            BlockScanResult blockResult = (BlockScanResult)result3;
            Vec3d resultPos = result3.getPosition();
            Vec3d toResult = resultPos.func_178788_d(viewerEyes);
            float lookDirDot = (float)lookVec.func_72430_b(toResult.func_72432_b());
            BlockState blockState = blockResult.getBlockState();
            ITextComponent label = blockState.func_177230_c().func_200291_n();
            if (!(lookDirDot > 0.98f) || Strings.isNullOrEmpty((String)label.getString())) continue;
            float distance = showDistance ? (float)resultPos.func_178788_d(viewerEyes).func_72433_c() : 0.0f;
            ScanResultProviderBlock.renderIconLabel(renderTypeBuffer, matrixStack, yaw, pitch, lookVec, viewerEyes, distance, resultPos, API.ICON_INFO, label);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.scanFilters.clear();
        this.scanFilterKeys.clear();
        this.max = null;
        this.min = null;
        this.blocksPerTick = 0;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.resultClusters.clear();
    }

    private static RenderType getBlockScanResultRenderLayer() {
        return RenderType.func_228632_a_((String)"scan_result", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)65536, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228512_d_).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228725_a_(new RenderState.TexturingState("shader", ScanResultShader.INSTANCE::bind, ScanResultShader.INSTANCE::unbind)).func_228728_a_(false));
    }

    private boolean tryAddToCluster(BlockPos pos, int stateId) {
        BlockPos min = pos.func_177982_a(-1, -1, -1);
        BlockPos max = pos.func_177982_a(1, 1, 1);
        BlockScanResult root = null;
        for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
            for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    BlockPos clusterPos = new BlockPos(x, y, z);
                    BlockScanResult cluster = this.resultClusters.get(clusterPos);
                    if (cluster == null || stateId != cluster.stateId) continue;
                    if (root == null) {
                        root = cluster.getRoot();
                        root.add(pos);
                        this.resultClusters.put(pos, root);
                        continue;
                    }
                    cluster.setRoot(root);
                }
            }
        }
        return root != null;
    }

    private boolean moveNext(World world) {
        ++this.y;
        if (this.y > this.max.func_177956_o() || this.y >= world.func_217301_I()) {
            this.y = this.min.func_177956_o();
            ++this.x;
            if (this.x > this.max.func_177958_n()) {
                this.x = this.min.func_177958_n();
                ++this.z;
                if (this.z > this.max.func_177952_p()) {
                    this.blocksPerTick = 0;
                    return false;
                }
            }
        }
        return true;
    }

    private ScanResultProviderBlock() {
    }

    private static final class BlockScanResult
    implements ScanResult {
        private final int stateId;
        private AxisAlignedBB bounds;
        @Nullable
        private BlockScanResult parent;
        private int color;

        BlockScanResult(int stateId, BlockPos pos) {
            this.bounds = new AxisAlignedBB(pos);
            this.stateId = stateId;
        }

        void computeColor(IBlockReader world) {
            BlockState blockState = this.getBlockState();
            this.color = blockState.func_185909_g((IBlockReader)world, (BlockPos)new BlockPos((Vec3d)this.bounds.func_189972_c())).field_76291_p;
            IFluidState fluidState = blockState.func_204520_s();
            if (!fluidState.func_206888_e()) {
                if (Settings.fluidColors.containsKey((Object)fluidState.func_206886_c())) {
                    this.color = Settings.fluidColors.getInt((Object)fluidState.func_206886_c());
                } else {
                    Settings.fluidTagColors.forEach((k, v) -> {
                        if (k.func_199685_a_((Object)fluidState.func_206886_c())) {
                            this.color = v;
                        }
                    });
                }
            } else if (Settings.blockColors.containsKey((Object)blockState.func_177230_c())) {
                this.color = Settings.blockColors.getInt((Object)blockState.func_177230_c());
            } else {
                Settings.blockTagColors.forEach((k, v) -> {
                    if (k.func_199685_a_((Object)blockState.func_177230_c())) {
                        this.color = v;
                    }
                });
            }
        }

        BlockState getBlockState() {
            return Block.func_196257_b((int)this.stateId);
        }

        int getColor() {
            return this.color;
        }

        boolean isRoot() {
            return this.parent == null;
        }

        BlockScanResult getRoot() {
            if (this.parent != null) {
                return this.parent.getRoot();
            }
            return this;
        }

        void setRoot(BlockScanResult root) {
            if (this.parent != null) {
                this.parent.setRoot(root);
                return;
            }
            if (root == this) {
                return;
            }
            root.bounds = root.bounds.func_111270_a(this.bounds);
            this.parent = root;
        }

        void add(BlockPos pos) {
            assert (this.parent == null) : "Trying to add to non-root node.";
            this.bounds = this.bounds.func_111270_a(new AxisAlignedBB(pos));
        }

        @Override
        @Nullable
        public AxisAlignedBB getRenderBounds() {
            return this.bounds;
        }

        @Override
        public Vec3d getPosition() {
            return this.bounds.func_189972_c();
        }
    }
}

