/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import li.cil.scannable.api.API;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.ScanFilterEntity;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScannerModuleEntity;
import li.cil.scannable.common.capabilities.CapabilityScannerModule;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public final class ScanResultProviderEntity
extends AbstractScanResultProvider {
    public static final ScanResultProviderEntity INSTANCE = new ScanResultProviderEntity();
    private final List<ScanFilterEntity> scanFilters = new ArrayList<ScanFilterEntity>();
    private AxisAlignedBB bounds;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int chunksPerTick;
    private int x;
    private int z;
    private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

    @Override
    public void initialize(PlayerEntity player, Collection<ItemStack> modules, Vec3d center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius, scanTicks);
        this.scanFilters.clear();
        for (ItemStack module : modules) {
            LazyOptional capability = module.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
            capability.filter(c -> c instanceof ScannerModuleEntity).ifPresent(c -> {
                Optional<ScanFilterEntity> filter = ((ScannerModuleEntity)c).getFilter(module);
                filter.ifPresent(this.scanFilters::add);
            });
        }
        this.bounds = new AxisAlignedBB(center.field_72450_a - (double)radius, center.field_72448_b - (double)radius, center.field_72449_c - (double)radius, center.field_72450_a + (double)radius, center.field_72448_b + (double)radius, center.field_72449_c + (double)radius);
        double maxEntityRadius = player.field_70170_p.getMaxEntityRadius();
        this.minX = MathHelper.func_76128_c((double)((this.bounds.field_72340_a - maxEntityRadius) / 16.0));
        this.maxX = MathHelper.func_76143_f((double)((this.bounds.field_72336_d + maxEntityRadius) / 16.0));
        this.minZ = MathHelper.func_76128_c((double)((this.bounds.field_72339_c - maxEntityRadius) / 16.0));
        this.maxZ = MathHelper.func_76143_f((double)((this.bounds.field_72334_f + maxEntityRadius) / 16.0));
        this.x = this.minX - 1;
        this.z = this.minZ;
        int count = (this.maxX - this.minX + 1) * (this.maxZ - this.minZ + 1);
        this.chunksPerTick = MathHelper.func_76123_f((float)((float)count / (float)scanTicks));
    }

    @Override
    public void computeScanResults(Consumer<ScanResult> callback) {
        World world = this.player.func_130014_f_();
        for (int i = 0; i < this.chunksPerTick; ++i) {
            if (!this.moveNext()) {
                return;
            }
            world.func_212866_a_(this.x, this.z).func_177430_a(LivingEntity.class, this.bounds, this.entities, this::FilterEntities);
            for (LivingEntity entity : this.entities) {
                Vec3d position;
                if (!entity.func_70089_S() || !(this.center.func_72438_d(position = entity.func_174791_d()) < (double)this.radius)) continue;
                ResourceLocation icon = API.ICON_INFO;
                for (ScanFilterEntity filter : this.scanFilters) {
                    Optional<ResourceLocation> filterIcon;
                    if (!filter.matches((Entity)entity) || !(filterIcon = filter.getIcon((Entity)entity)).isPresent()) continue;
                    icon = filterIcon.get();
                    break;
                }
                callback.accept(new ScanResultEntity((Entity)entity, icon));
            }
            this.entities.clear();
        }
    }

    @Override
    public void render(IRenderTypeBuffer renderTypeBuffer, MatrixStack matrixStack, Matrix4f projectionMatrix, ActiveRenderInfo renderInfo, float partialTicks, List<ScanResult> results) {
        float yaw = renderInfo.func_216778_f();
        float pitch = renderInfo.func_216777_e();
        Vec3d lookVec = new Vec3d(renderInfo.func_227996_l_());
        Vec3d viewerEyes = renderInfo.func_216785_c();
        boolean showDistance = renderInfo.func_216773_g().func_225608_bj_();
        results.sort(Comparator.comparing(result -> {
            ScanResultEntity resultEntity = (ScanResultEntity)result;
            Vec3d entityEyes = resultEntity.entity.func_174824_e(partialTicks);
            Vec3d toResult = entityEyes.func_178788_d(viewerEyes);
            return lookVec.func_72430_b(toResult.func_72432_b());
        }));
        for (ScanResult result2 : results) {
            ScanResultEntity resultEntity = (ScanResultEntity)result2;
            ITextComponent name = resultEntity.entity.func_200200_C_();
            ResourceLocation icon = resultEntity.getIcon();
            Vec3d resultPos = resultEntity.entity.func_174824_e(partialTicks);
            float distance = showDistance ? (float)resultPos.func_178788_d(viewerEyes).func_72433_c() : 0.0f;
            ScanResultProviderEntity.renderIconLabel(renderTypeBuffer, matrixStack, yaw, pitch, lookVec, viewerEyes, distance, resultPos, icon, name);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.scanFilters.clear();
        this.bounds = null;
        this.maxZ = 0;
        this.minZ = 0;
        this.maxX = 0;
        this.minX = 0;
        this.chunksPerTick = 0;
        this.z = 0;
        this.x = 0;
        this.entities.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean moveNext() {
        ++this.x;
        if (this.x > this.maxX) {
            this.x = this.minX;
            ++this.z;
            if (this.z > this.maxZ) {
                this.chunksPerTick = 0;
                return false;
            }
        }
        return true;
    }

    private <T extends Entity> boolean FilterEntities(T entity) {
        return this.scanFilters.stream().anyMatch(f -> f.matches(entity));
    }

    private ScanResultProviderEntity() {
    }

    private static final class ScanResultEntity
    implements ScanResult {
        private final Entity entity;
        private final ResourceLocation icon;

        ScanResultEntity(Entity entity, ResourceLocation icon) {
            this.entity = entity;
            this.icon = icon;
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }

        @Override
        public Vec3d getPosition() {
            return this.entity.func_174791_d();
        }

        @Override
        public AxisAlignedBB getRenderBounds() {
            return this.entity.func_184177_bl();
        }
    }
}

