/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import li.cil.scannable.api.API;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.common.capabilities.CapabilityScannerModule;
import li.cil.scannable.common.item.ItemScannerModuleStructure;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.MessageStructureRequest;
import li.cil.scannable.common.scanning.ScannerModuleStructure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ScanResultProviderStructure
extends AbstractScanResultProvider {
    public static final ScanResultProviderStructure INSTANCE = new ScanResultProviderStructure();
    private static final StructureLocation[] EMPTY = new StructureLocation[0];
    private boolean hideExplored;
    private int requestDelay;
    private State state;
    private StructureLocation[] structures = EMPTY;

    public void setStructures(StructureLocation[] structures) {
        if (this.state != State.WAIT_RESPONSE) {
            return;
        }
        this.structures = structures;
        this.state = State.WAIT_RESULT;
    }

    @Override
    public void initialize(PlayerEntity player, Collection<ItemStack> modules, Vec3d center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius * 2.0f, scanTicks);
        this.hideExplored = false;
        for (ItemStack module : modules) {
            module.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY).filter(c -> c instanceof ScannerModuleStructure).ifPresent(c -> this.hideExplored |= ItemScannerModuleStructure.shouldHideExplored(module));
        }
        this.requestDelay = scanTicks / 4;
        this.state = State.WAIT_REQUEST;
        this.structures = EMPTY;
    }

    @Override
    public void computeScanResults(Consumer<ScanResult> callback) {
        switch (this.state) {
            case WAIT_REQUEST: {
                if (this.requestDelay-- > 0) {
                    return;
                }
                Network.INSTANCE.sendToServer((Object)new MessageStructureRequest(this.player.func_130014_f_(), new BlockPos(this.center), this.radius, this.hideExplored));
                this.state = State.WAIT_RESPONSE;
                break;
            }
            case WAIT_RESULT: {
                float renderDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16;
                float sqRenderDistance = renderDistance * renderDistance;
                for (StructureLocation structure : this.structures) {
                    Vec3d structureCenter = new Vec3d((Vec3i)structure.pos);
                    Vec3d toStructure = structureCenter.func_178788_d(this.center);
                    if (toStructure.func_189985_c() > (double)sqRenderDistance) {
                        Vec3d clippedPos = this.center.func_178787_e(toStructure.func_72432_b().func_186678_a((double)(renderDistance - 4.0f)));
                        callback.accept(new ScanResultStructure(structure, clippedPos));
                        continue;
                    }
                    callback.accept(new ScanResultStructure(structure, structureCenter));
                }
                this.structures = EMPTY;
                this.state = State.COMPLETE;
                break;
            }
        }
    }

    @Override
    public void render(IRenderTypeBuffer renderTypeBuffer, MatrixStack matrixStack, Matrix4f projectionMatrix, ActiveRenderInfo renderInfo, float partialTicks, List<ScanResult> results) {
        float yaw = renderInfo.func_216778_f();
        float pitch = renderInfo.func_216777_e();
        Vec3d lookVec = new Vec3d(renderInfo.func_227996_l_());
        Vec3d viewerEyes = renderInfo.func_216785_c();
        boolean showDistance = renderInfo.func_216773_g().func_225608_bj_();
        float renderDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16;
        float sqRenderDistance = renderDistance * renderDistance;
        for (ScanResult result : results) {
            ScanResultStructure resultStructure = (ScanResultStructure)result;
            Vec3d structureCenter = new Vec3d((double)((ScanResultStructure)resultStructure).structure.pos.func_177958_n() + 0.5, (double)((ScanResultStructure)resultStructure).structure.pos.func_177956_o() + 0.5, (double)((ScanResultStructure)resultStructure).structure.pos.func_177952_p() + 0.5);
            Vec3d toStructure = structureCenter.func_178788_d(viewerEyes);
            Vec3d resultPos = toStructure.func_189985_c() > (double)sqRenderDistance ? viewerEyes.func_178787_e(toStructure.func_72432_b().func_186678_a((double)(renderDistance / 2.0f))) : structureCenter;
            ITextComponent name = ((ScanResultStructure)resultStructure).structure.name;
            ResourceLocation icon = API.ICON_INFO;
            float distance = showDistance ? (float)structureCenter.func_178788_d(viewerEyes).func_72433_c() : 0.0f;
            ScanResultProviderStructure.renderIconLabel(renderTypeBuffer, matrixStack, yaw, pitch, lookVec, viewerEyes, distance, resultPos, icon, name);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.requestDelay = 0;
        this.state = State.WAIT_REQUEST;
        this.structures = EMPTY;
    }

    private ScanResultProviderStructure() {
    }

    private static final class ScanResultStructure
    implements ScanResult {
        private final StructureLocation structure;
        private final Vec3d center;
        private final AxisAlignedBB bounds;

        ScanResultStructure(StructureLocation structure, Vec3d renderCenter) {
            this.structure = structure;
            this.center = renderCenter;
            this.bounds = new AxisAlignedBB(new BlockPos(renderCenter)).func_72314_b(8.0, 8.0, 8.0);
        }

        @Override
        public Vec3d getPosition() {
            return this.center;
        }

        @Override
        @Nullable
        public AxisAlignedBB getRenderBounds() {
            return this.bounds;
        }
    }

    private static enum State {
        WAIT_REQUEST,
        WAIT_RESPONSE,
        WAIT_RESULT,
        COMPLETE;

    }

    public static final class StructureLocation {
        public final ITextComponent name;
        public final BlockPos pos;

        public StructureLocation(ITextComponent name, BlockPos pos) {
            this.name = name;
            this.pos = pos;
        }
    }
}

