/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning.filter;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import li.cil.scannable.api.scanning.ScanFilterBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public final class ScanFilterCache
implements ScanFilterBlock {
    private final IntSet stateIds;

    public ScanFilterCache(Collection<ScanFilterBlock> filters) {
        this.stateIds = ScanFilterCache.buildCache(filters);
    }

    @Override
    public boolean matches(BlockState state) {
        return this.stateIds.contains(Block.func_196246_j((BlockState)state));
    }

    private static IntSet buildCache(Collection<ScanFilterBlock> filters) {
        IntArrayList list = new IntArrayList();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            for (BlockState blockState : block.func_176194_O().func_177619_a()) {
                if (!filters.stream().anyMatch(f -> f.matches(blockState))) continue;
                list.add(Block.func_196246_j((BlockState)blockState));
            }
        }
        if (list.size() > 10) {
            return new IntOpenHashSet((IntCollection)list);
        }
        return new IntArraySet((IntCollection)list);
    }
}

