/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.shader;

import java.io.IOException;
import li.cil.scannable.common.Scannable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderInstance;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public abstract class AbstractShader {
    private static final long START_TIME = System.currentTimeMillis();
    protected ShaderInstance shaderInstance;
    protected ShaderDefault timeUniform;

    public void initialize() {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        Minecraft.func_71410_x().func_213165_a(() -> this.reloadShaders(resourceManager));
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(manager, predicate) -> {
                if (predicate.test(VanillaResourceType.SHADERS)) {
                    this.reloadShaders(manager);
                }
            }));
        }
    }

    public void bind() {
        if (this.shaderInstance != null) {
            this.timeUniform.func_148090_a((float)(System.currentTimeMillis() - START_TIME) / 1000.0f);
            this.shaderInstance.func_216535_f();
        }
    }

    public void unbind() {
        if (this.shaderInstance != null) {
            this.shaderInstance.func_216544_e();
        }
    }

    private void reloadShaders(IResourceManager manager) {
        if (this.shaderInstance != null) {
            this.shaderInstance.close();
            this.shaderInstance = null;
        }
        try {
            this.shaderInstance = new ShaderInstance(manager, this.getShaderName());
            this.handleShaderLoad();
        }
        catch (IOException e) {
            Scannable.getLog().error((Object)e);
        }
    }

    protected abstract String getShaderName();

    protected void handleShaderLoad() {
        this.timeUniform = this.shaderInstance.func_216538_b("Time");
    }
}

