/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common;

import li.cil.scannable.api.API;
import li.cil.scannable.client.InitializerClient;
import li.cil.scannable.common.InitializerCommon;
import li.cil.scannable.common.ScannableItemGroup;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.container.ContainerScanner;
import li.cil.scannable.common.item.ItemScanner;
import li.cil.scannable.common.item.ItemScannerModuleAnimal;
import li.cil.scannable.common.item.ItemScannerModuleBlank;
import li.cil.scannable.common.item.ItemScannerModuleBlockConfigurable;
import li.cil.scannable.common.item.ItemScannerModuleBlockFluid;
import li.cil.scannable.common.item.ItemScannerModuleBlockOreCommon;
import li.cil.scannable.common.item.ItemScannerModuleBlockOreRare;
import li.cil.scannable.common.item.ItemScannerModuleEntityConfigurable;
import li.cil.scannable.common.item.ItemScannerModuleMonster;
import li.cil.scannable.common.item.ItemScannerModuleRange;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="scannable")
public final class Scannable {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"scannable");
    public static final RegistryObject<Item> MODULE_BLANK = ITEMS.register("module_blank", ItemScannerModuleBlank::new);
    public static final RegistryObject<Item> MODULE_RANGE = ITEMS.register("module_range", ItemScannerModuleRange::new);
    public static final RegistryObject<Item> MODULE_ENTITY = ITEMS.register("module_entity", ItemScannerModuleEntityConfigurable::new);
    public static final RegistryObject<Item> MODULE_ANIMAL = ITEMS.register("module_animal", ItemScannerModuleAnimal::new);
    public static final RegistryObject<Item> MODULE_MONSTER = ITEMS.register("module_monster", ItemScannerModuleMonster::new);
    public static final RegistryObject<Item> MODULE_BLOCK = ITEMS.register("module_block", ItemScannerModuleBlockConfigurable::new);
    public static final RegistryObject<Item> MODULE_ORE_COMMON = ITEMS.register("module_ore_common", ItemScannerModuleBlockOreCommon::new);
    public static final RegistryObject<Item> MODULE_ORE_RARE = ITEMS.register("module_ore_rare", ItemScannerModuleBlockOreRare::new);
    public static final RegistryObject<Item> MODULE_FLUID = ITEMS.register("module_fluid", ItemScannerModuleBlockFluid::new);
    public static final RegistryObject<Item> SCANNER = ITEMS.register("scanner", ItemScanner::new);
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"scannable");
    public static final RegistryObject<ContainerType<ContainerScanner>> SCANNER_CONTAINER = CONTAINERS.register("scanner", () -> IForgeContainerType.create(ContainerScanner::createForClient));
    public static final Tag<Item> MODULES = new ItemTags.Wrapper(new ResourceLocation("scannable", "modules"));
    private static final Logger LOGGER = LogManager.getLogger();

    public Scannable() {
        Settings.register();
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        API.itemGroup = new ScannableItemGroup();
        DistExecutor.safeRunForDist(() -> InitializerClient::new, () -> InitializerCommon::new);
    }

    public static Logger getLog() {
        return LOGGER;
    }
}

