/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.container;

import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.inventory.ItemHandlerScanner;
import li.cil.scannable.common.item.ItemScanner;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public final class ContainerScanner
extends Container {
    private final PlayerEntity player;
    private final Hand hand;

    public static ContainerScanner createForServer(int windowId, PlayerInventory inventory, Hand hand, ItemHandlerScanner itemHandler) {
        return new ContainerScanner(windowId, inventory, hand, itemHandler);
    }

    public static ContainerScanner createForClient(int windowId, PlayerInventory inventory, PacketBuffer buffer) {
        Hand hand = (Hand)buffer.func_179257_a(Hand.class);
        return new ContainerScanner(windowId, inventory, hand, new ItemHandlerScanner(inventory.field_70458_d.func_184586_b(hand)));
    }

    public ContainerScanner(int windowId, PlayerInventory inventory, Hand hand, ItemHandlerScanner itemHandler) {
        super((ContainerType)Scannable.SCANNER_CONTAINER.get(), windowId);
        int slot;
        this.player = inventory.field_70458_d;
        this.hand = hand;
        IItemHandler activeModules = itemHandler.getActiveModules();
        for (int slot2 = 0; slot2 < activeModules.getSlots(); ++slot2) {
            this.func_75146_a((Slot)new SlotItemHandler(activeModules, slot2, 62 + slot2 * 18, 20));
        }
        IItemHandler storedModules = itemHandler.getInactiveModules();
        for (slot = 0; slot < storedModules.getSlots(); ++slot) {
            this.func_75146_a((Slot)new SlotItemHandler(storedModules, slot, 62 + slot * 18, 46));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inventory, col + row * 9 + 9, 8 + col * 18, row * 18 + 77));
            }
        }
        for (slot = 0; slot < 9; ++slot) {
            this.func_75146_a(new Slot((IInventory)inventory, slot, 8 + slot * 18, 135));
        }
    }

    public Hand getHand() {
        return this.hand;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player == this.player && ItemScanner.isScanner(player.func_184586_b(this.hand));
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot into;
        int i;
        int begin;
        int step;
        Slot from = (Slot)this.field_75151_b.get(index);
        if (from == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = from.func_75211_c().func_77946_l();
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean intoPlayerInventory = from.field_75224_c != player.field_71071_by;
        ItemStack fromStack = from.func_75211_c();
        if (intoPlayerInventory) {
            step = -1;
            begin = this.field_75151_b.size() - 1;
        } else {
            step = 1;
            begin = 0;
        }
        if (fromStack.func_77976_d() > 1) {
            for (i = begin; i >= 0 && i < this.field_75151_b.size(); i += step) {
                int itemsMoved;
                int maxSizeInSlot;
                int spaceInSlot;
                boolean itemsAreEqual;
                ItemStack intoStack;
                into = (Slot)this.field_75151_b.get(i);
                if (into.field_75224_c == from.field_75224_c || (intoStack = into.func_75211_c()).func_190926_b()) continue;
                boolean bl = itemsAreEqual = fromStack.func_77969_a(intoStack) && ItemStack.func_77970_a((ItemStack)fromStack, (ItemStack)intoStack);
                if (!itemsAreEqual || (spaceInSlot = (maxSizeInSlot = Math.min(fromStack.func_77976_d(), into.func_178170_b(stack))) - intoStack.func_190916_E()) <= 0 || (itemsMoved = Math.min(spaceInSlot, fromStack.func_190916_E())) <= 0) continue;
                intoStack.func_190917_f(from.func_75209_a(itemsMoved).func_190916_E());
                into.func_75218_e();
                if (from.func_75211_c().func_190926_b()) break;
            }
        }
        for (i = begin; i >= 0 && i < this.field_75151_b.size() && !from.func_75211_c().func_190926_b(); i += step) {
            into = (Slot)this.field_75151_b.get(i);
            if (into.field_75224_c == from.field_75224_c || into.func_75216_d() || !into.func_75214_a(fromStack)) continue;
            int maxSizeInSlot = Math.min(fromStack.func_77976_d(), into.func_178170_b(fromStack));
            int itemsMoved = Math.min(maxSizeInSlot, fromStack.func_190916_E());
            into.func_75215_d(from.func_75209_a(itemsMoved));
        }
        return from.func_75211_c().func_190916_E() < stack.func_190916_E() ? from.func_75211_c() : ItemStack.field_190927_a;
    }
}

