/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.energy;

import li.cil.scannable.common.config.Settings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public final class EnergyStorageScanner
extends EnergyStorage
implements INBTSerializable<IntNBT> {
    private static final String TAG_ENERGY = "energy";
    private final ItemStack container;

    public EnergyStorageScanner(ItemStack container) {
        super(Settings.energyCapacityScanner);
        this.container = container;
    }

    public void updateFromNBT() {
        CompoundNBT nbt = this.container.func_77978_p();
        if (nbt != null && nbt.func_150297_b(TAG_ENERGY, 3)) {
            this.deserializeNBT((IntNBT)nbt.func_74781_a(TAG_ENERGY));
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!Settings.useEnergy) {
            return 0;
        }
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (!simulate && energyReceived != 0) {
            this.container.func_77983_a(TAG_ENERGY, (INBT)this.serializeNBT());
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!Settings.useEnergy) {
            return 0;
        }
        int energyExtracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate && energyExtracted != 0) {
            this.container.func_77983_a(TAG_ENERGY, (INBT)this.serializeNBT());
        }
        return energyExtracted;
    }

    public IntNBT serializeNBT() {
        return IntNBT.func_229692_a_((int)this.energy);
    }

    public void deserializeNBT(IntNBT nbt) {
        this.energy = nbt.func_150287_d();
    }
}

