/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Constants;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.item.AbstractItemScannerModuleBlock;
import li.cil.scannable.common.scanning.ScannerModuleBlockConfigurable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemScannerModuleBlockConfigurable
extends AbstractItemScannerModuleBlock {
    private static final String TAG_BLOCK = "block";

    public static Optional<Block> getBlock(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b(TAG_BLOCK, 8)) {
            return Optional.empty();
        }
        ResourceLocation registryName = new ResourceLocation(nbt.func_74779_i(TAG_BLOCK));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryName);
        if (block == null || block == Blocks.field_150350_a) {
            return Optional.empty();
        }
        return Optional.of(block);
    }

    public static void setBlock(ItemStack stack, Block block) {
        CompoundNBT nbt = stack.func_196082_o();
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return;
        }
        nbt.func_74778_a(TAG_BLOCK, registryName.toString());
    }

    public ItemScannerModuleBlockConfigurable() {
        super(ScannerModuleBlockConfigurable.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Optional<Block> block = ItemScannerModuleBlockConfigurable.getBlock(stack);
        if (!block.isPresent()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_block", new Object[0]));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_block.name", new Object[]{block.get().func_200291_n()}));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.func_175623_d(context.func_195995_a())) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        BlockState state = world.func_180495_p(context.func_195995_a());
        Block block = state.func_177230_c();
        if (Settings.shouldIgnore(block)) {
            if (world.field_72995_K) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TranslationTextComponent("message.scannable.block_blacklisted", new Object[0]), Constants.CHAT_LINE_ID);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 10);
            return ActionResultType.SUCCESS;
        }
        ItemScannerModuleBlockConfigurable.setBlock(stack, block);
        return ActionResultType.SUCCESS;
    }
}

