/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.common.item.AbstractItemScannerModuleEntity;
import li.cil.scannable.common.scanning.ScannerModuleEntityConfigurable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ItemScannerModuleEntityConfigurable
extends AbstractItemScannerModuleEntity {
    private static final String TAG_ENTITY = "entity";

    public static Optional<EntityType<?>> getEntityType(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b(TAG_ENTITY, 8)) {
            return Optional.empty();
        }
        return EntityType.func_220327_a((String)nbt.func_74779_i(TAG_ENTITY));
    }

    private static void setEntityType(ItemStack stack, EntityType<?> entityType) {
        ResourceLocation entityRegistryName = entityType.getRegistryName();
        if (entityRegistryName == null) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a(TAG_ENTITY, entityRegistryName.toString());
    }

    public ItemScannerModuleEntityConfigurable() {
        super(ScannerModuleEntityConfigurable.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Optional<EntityType<?>> entity = ItemScannerModuleEntityConfigurable.getEntityType(stack);
        if (!entity.isPresent()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_entity", new Object[0]));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_entity.name", new Object[]{entity.get().func_212546_e()}));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        ItemScannerModuleEntityConfigurable.setEntityType(player.func_184586_b(hand), target.func_200600_R());
        player.func_184609_a(hand);
        player.field_71071_by.func_70296_d();
        return true;
    }
}

