/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.common.capabilities.CapabilityProviderModule;
import li.cil.scannable.common.item.AbstractItemScannerModule;
import li.cil.scannable.common.scanning.ScannerModuleStructure;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class ItemScannerModuleStructure
extends AbstractItemScannerModule {
    private static final String TAG_HIDE_EXPLORED = "hideExplored";
    private static final ICapabilityProvider CAPABILITY_PROVIDER = new CapabilityProviderModule(ScannerModuleStructure.INSTANCE);

    public static boolean shouldHideExplored(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n(TAG_HIDE_EXPLORED);
    }

    public static void setHideExplored(ItemStack stack, boolean hideExplored) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74757_a(TAG_HIDE_EXPLORED, hideExplored);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return CAPABILITY_PROVIDER;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_structure", new Object[0]));
        if (ItemScannerModuleStructure.shouldHideExplored(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_structure.hide_explored", new Object[0]));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_structure.show_explored", new Object[0]));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_225608_bj_()) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        ItemScannerModuleStructure.setHideExplored(stack, !ItemScannerModuleStructure.shouldHideExplored(stack));
        return ActionResult.func_226248_a_((Object)stack);
    }
}

