/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.function.Supplier;
import li.cil.scannable.client.scanning.ScanResultProviderStructure;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.MessageStructureResponse;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageStructureRequest {
    private DimensionType dimension;
    private BlockPos center;
    private int radius;
    private boolean skipExistingChunks;

    public MessageStructureRequest(World world, BlockPos center, float radius, boolean skipExistingChunks) {
        this.dimension = world.func_201675_m().func_186058_p();
        this.center = center;
        this.radius = (int)Math.ceil(radius);
        this.skipExistingChunks = skipExistingChunks;
    }

    public MessageStructureRequest(ByteBuf buffer) {
        this.fromBytes(buffer);
    }

    public static boolean handle(MessageStructureRequest message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            DimensionType dimension = message.dimension;
            ServerPlayerEntity sender = context.getSender();
            if (sender == null) {
                return;
            }
            MinecraftServer server = sender.func_184102_h();
            if (server == null) {
                return;
            }
            ServerWorld world = server.func_71218_a(dimension);
            BlockPos center = message.center;
            int radius = message.radius;
            boolean skipExistingChunks = message.skipExistingChunks;
            ArrayList<ScanResultProviderStructure.StructureLocation> structures = new ArrayList<ScanResultProviderStructure.StructureLocation>();
            float sqRadius = radius * radius;
            for (String name : Settings.structures) {
                BlockPos pos = world.func_211157_a(name, center, radius, skipExistingChunks);
                if (pos == null || !(center.func_177951_i((Vec3i)pos) <= (double)sqRadius)) continue;
                TranslationTextComponent localizedName = new TranslationTextComponent("structure." + name, new Object[0]);
                structures.add(new ScanResultProviderStructure.StructureLocation((ITextComponent)localizedName, pos));
            }
            if (structures.isEmpty()) {
                return;
            }
            Network.INSTANCE.reply((Object)new MessageStructureResponse(structures.toArray(new ScanResultProviderStructure.StructureLocation[0])), context);
        });
        return true;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.dimension = DimensionType.func_186069_a((int)packet.func_150792_a());
        this.center = packet.func_179259_c();
        this.radius = packet.func_150792_a();
        this.skipExistingChunks = packet.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.func_150787_b(this.dimension.func_186068_a());
        packet.func_179255_a(this.center);
        packet.func_150787_b(this.radius);
        packet.writeBoolean(this.skipExistingChunks);
    }
}

