/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network.message;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import li.cil.scannable.client.scanning.ScanResultProviderStructure;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageStructureResponse {
    private ScanResultProviderStructure.StructureLocation[] structures;

    public MessageStructureResponse(ScanResultProviderStructure.StructureLocation[] structures) {
        this.structures = structures;
    }

    public MessageStructureResponse(ByteBuf buffer) {
        this.fromBytes(buffer);
    }

    public static boolean handle(MessageStructureResponse message, Supplier<NetworkEvent.Context> context) {
        ScanResultProviderStructure.INSTANCE.setStructures(message.structures);
        return true;
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBuffer packet = new PacketBuffer(buffer);
        int length = packet.readInt();
        this.structures = new ScanResultProviderStructure.StructureLocation[length];
        for (int i = 0; i < length; ++i) {
            ITextComponent name = packet.func_179258_d();
            BlockPos pos = packet.func_179259_c();
            this.structures[i] = new ScanResultProviderStructure.StructureLocation(name, pos);
        }
    }

    public void toBytes(ByteBuf buffer) {
        PacketBuffer packet = new PacketBuffer(buffer);
        packet.writeInt(this.structures.length);
        for (ScanResultProviderStructure.StructureLocation structure : this.structures) {
            packet.func_179256_a(structure.name);
            packet.func_179255_a(structure.pos);
        }
    }
}

