/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import java.util.Optional;
import li.cil.scannable.api.API;
import li.cil.scannable.api.scanning.ScanFilterBlock;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.api.scanning.ScannerModuleBlock;
import li.cil.scannable.client.scanning.filter.ScanFilterSingleBlock;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.item.ItemScannerModuleBlockConfigurable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum ScannerModuleBlockConfigurable implements ScannerModuleBlock
{
    INSTANCE;


    @Override
    public int getEnergyCost(PlayerEntity player, ItemStack module) {
        return Settings.energyCostModuleBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)GameRegistry.findRegistry(ScanResultProvider.class).getValue(API.SCAN_RESULT_PROVIDER_BLOCKS);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * 0.5f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<ScanFilterBlock> getFilter(ItemStack module) {
        Optional<Block> block = ItemScannerModuleBlockConfigurable.getBlock(module);
        return block.map(ScanFilterSingleBlock::new);
    }
}

