/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import java.util.ArrayList;
import java.util.Optional;
import li.cil.scannable.api.API;
import li.cil.scannable.api.scanning.ScanFilterBlock;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.api.scanning.ScannerModuleBlock;
import li.cil.scannable.client.scanning.filter.ScanFilterBlockTag;
import li.cil.scannable.client.scanning.filter.ScanFilterCache;
import li.cil.scannable.client.scanning.filter.ScanFilterRareOreCatchAll;
import li.cil.scannable.client.scanning.filter.ScanFilterSingleBlock;
import li.cil.scannable.common.config.Settings;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum ScannerModuleOreRare implements ScannerModuleBlock
{
    INSTANCE;

    @OnlyIn(value=Dist.CLIENT)
    ScanFilterBlock filter;

    @Override
    public int getEnergyCost(PlayerEntity player, ItemStack module) {
        return Settings.energyCostModuleOreCommon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)GameRegistry.findRegistry(ScanResultProvider.class).getValue(API.SCAN_RESULT_PROVIDER_BLOCKS);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * 0.25f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<ScanFilterBlock> getFilter(ItemStack module) {
        this.validateFilter();
        return Optional.of(this.filter);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        ArrayList<ScanFilterBlock> filters = new ArrayList<ScanFilterBlock>();
        for (Block block : Settings.rareOreBlocks) {
            filters.add(new ScanFilterSingleBlock(block));
        }
        for (Tag tag : Settings.rareOreBlockTags) {
            filters.add(new ScanFilterBlockTag((Tag<Block>)tag));
        }
        filters.add(ScanFilterRareOreCatchAll.INSTANCE);
        this.filter = new ScanFilterCache(filters);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        ScannerModuleOreRare.INSTANCE.filter = null;
    }
}

