/*
 * Decompiled with CFR 0.152.
 */
package erebus.block;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.core.helper.Utils;
import erebus.tileentity.TileEntityPreservedBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class BlockPreservedBlock
extends BlockContainer {
    public BlockPreservedBlock() {
        super(Material.field_151592_s);
        this.func_149711_c(10.0f);
        this.func_149672_a(field_149778_k);
        this.func_149663_c("erebus.preservedBlock");
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int meta = world.func_72805_g(x, y, z) + 1;
        if (meta > 9) {
            meta = 6;
        } else if (meta > 5) {
            meta = 2;
        }
        world.func_72921_c(x, y, z, meta, 2);
        return true;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        int rotation;
        TileEntityPreservedBlock tile;
        if (!world.field_72995_K && stack.func_77942_o() && (tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityPreservedBlock.class)) != null) {
            tile.setEntityNBT(stack.func_77978_p().func_74775_l("EntityNBT"));
        }
        if ((rotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0) {
            world.func_72921_c(x, y, z, 2 + 4 * stack.func_77960_j(), 2);
        } else if (rotation == 1) {
            world.func_72921_c(x, y, z, 5 + 4 * stack.func_77960_j(), 2);
        } else if (rotation == 2) {
            world.func_72921_c(x, y, z, 3 + 4 * stack.func_77960_j(), 2);
        } else if (rotation == 3) {
            world.func_72921_c(x, y, z, 4 + 4 * stack.func_77960_j(), 2);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPreservedBlock();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntityPreservedBlock tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityPreservedBlock.class);
        if (tile != null) {
            ItemStack stack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) > 5 ? 1 : 0);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("EntityNBT", (NBTBase)tile.getEntityNBT());
            stack.func_77982_d(nbt);
            return stack;
        }
        return new ItemStack(ModBlocks.amber, 1, world.func_72805_g(x, y, z) > 5 ? 0 : 1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        return block == this || block == ModBlocks.amber ? false : super.func_149646_a(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return ModBlocks.amber.func_149691_a(side, meta > 5 ? 0 : 1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        World world = event.world;
        EntityPlayer player = event.getPlayer();
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        TileEntityPreservedBlock tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityPreservedBlock.class);
        if (tile != null) {
            if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
                ItemStack stack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) > 5 ? 1 : 0);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74782_a("EntityNBT", (NBTBase)tile.getEntityNBT());
                stack.func_77982_d(nbt);
                this.func_149642_a(world, x, y, z, stack);
            } else {
                tile.spawnTrappedEntity();
            }
        }
    }
}

