/*
 * Decompiled with CFR 0.152.
 */
package erebus.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.teleporter.TeleporterHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ErebusPortal
extends Block {
    public ErebusPortal() {
        super(Material.field_151567_E);
        this.func_149715_a(1.0f);
        this.func_149722_s();
        this.func_149663_c("erebus.portal");
        this.func_149672_a(Block.field_149778_k);
        this.func_149658_d("erebus:portal");
    }

    public static boolean obeysPortalRule(World world, int x, int y, int z, boolean actualPortal) {
        int neighborPortals = 0;
        int axisFlag = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int atX = x + dir.offsetX;
            int atY = y + dir.offsetY;
            int atZ = z + dir.offsetZ;
            Block at = world.func_147439_a(atX, atY, atZ);
            if (!ErebusPortal.isSubstrate(at, actualPortal)) continue;
            int opX = x - dir.offsetX;
            int opY = y - dir.offsetY;
            int opZ = z - dir.offsetZ;
            Block op = world.func_147439_a(opX, opY, opZ);
            if (!op.func_149721_r() && !ErebusPortal.isSubstrate(op, actualPortal)) {
                return false;
            }
            ++neighborPortals;
            axisFlag |= 1 << (dir.ordinal() >> 1);
        }
        if (neighborPortals < 1) {
            return false;
        }
        return axisFlag != 7;
    }

    private static boolean isSubstrate(Block block, boolean portalNotLeaf) {
        return portalNotLeaf ? block instanceof ErebusPortal : block instanceof BlockLeaves;
    }

    public void func_149695_a(World w, int x, int y, int z, Block neighbor) {
        if (!ErebusPortal.obeysPortalRule(w, x, y, z, true)) {
            w.func_147468_f(x, y, z);
        }
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        if (entity.field_70154_o == null && entity.field_70153_n == null && entity.field_71088_bW <= 0) {
            if (entity.field_71093_bK == 0 || entity.field_71093_bK == 1) {
                TeleporterHandler.transferToErebus(entity);
            } else {
                TeleporterHandler.transferToOverworld(entity);
            }
            if (entity != null) {
                entity.field_71088_bW = ConfigHandler.INSTANCE.portalCooldown * 20;
            }
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_147439_a(x, y, z) != this;
    }
}

