/*
 * Decompiled with CFR 0.152.
 */
package erebus.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.block.ErebusPortal;
import erebus.tileentity.TileEntityGaeanKeystone;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GaeanKeystone
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    static int LEAF_SEARCH = 8;
    static int MAX_PORTAL_SIZE = 81;
    static final byte F = 1;
    static final byte L = 2;
    static final byte END = -1;
    static final byte[] portalFrame = new byte[]{0, 1, 1, 1, 0, -1, 1, 2, 2, 2, 1, -1, 1, 2, 2, 2, 1, -1, 1, 2, 2, 2, 1, -1, 0, 1, 1, 1, 0, -1};

    public GaeanKeystone() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149647_a(ModTabs.blocks);
        this.func_149663_c("erebus.gaeanKeystone");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.8125f, 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[3];
        this.icons[0] = reg.func_94245_a("erebus:keystone_top");
        this.icons[1] = reg.func_94245_a("erebus:keystone_sides");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.icons[0] : (side == 0 ? Blocks.field_150417_aV.func_149691_a(0, 1) : this.icons[1]);
    }

    public static boolean isGemActive(int metadata) {
        return metadata > 0;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack held = player.func_71045_bC();
        if (world.func_72805_g(x, y, z) > 0) {
            if (held != null) {
                return true;
            }
            this.breakPortal(world, x, y, z);
            world.func_72921_c(x, y, z, 0, 3);
            player.func_70062_b(0, new ItemStack(ModItems.portalActivator));
            return true;
        }
        if (held == null || held.func_77973_b() != ModItems.portalActivator) {
            return false;
        }
        if (this.makePortal(world, x, y, z)) {
            world.func_72921_c(x, y, z, 1, 3);
            player.func_70062_b(0, null);
        } else {
            world.func_72921_c(x, y, z, 0, 3);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityGaeanKeystone();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        if (meta > 0) {
            this.breakPortal(world, x, y, z);
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.portalActivator)));
        }
    }

    void breakPortal(World w, int x, int y, int z) {
        PCoord here = new PCoord(w, x, y, z);
        PCoord min = here.add(-LEAF_SEARCH, -LEAF_SEARCH, -LEAF_SEARCH);
        PCoord max = here.add(LEAF_SEARCH, LEAF_SEARCH, LEAF_SEARCH);
        PCoord.iterateCube(min, max, new PCoord.ICoordFunc(){

            @Override
            public boolean visit(PCoord at) {
                if (!at.is(ModBlocks.portal)) {
                    return false;
                }
                HashSet<PCoord> found = new HashSet<PCoord>();
                ArrayList<PCoord> frontier = new ArrayList<PCoord>();
                frontier.add(at);
                while (!frontier.isEmpty()) {
                    PCoord f = (PCoord)frontier.remove(frontier.size() - 1);
                    found.add(f);
                    for (PCoord pc : f.neighbors()) {
                        if (found.contains(pc) || !pc.is(ModBlocks.portal)) continue;
                        frontier.add(pc);
                    }
                }
                for (PCoord pc : found) {
                    pc.setBlockNoNotify(Blocks.field_150350_a);
                }
                return true;
            }
        });
    }

    boolean makePortal(World w, int x, int y, int z) {
        PCoord keystone = new PCoord(w, x, y, z);
        final HashSet badLeaves = new HashSet();
        final HashSet contig = new HashSet();
        PCoord min = keystone.add(-LEAF_SEARCH, -LEAF_SEARCH, -LEAF_SEARCH);
        PCoord max = keystone.add(LEAF_SEARCH, LEAF_SEARCH, LEAF_SEARCH);
        PCoord.iterateCube(min, max, new PCoord.ICoordFunc(){

            @Override
            public boolean visit(PCoord at) {
                if (!at.isLeaf()) {
                    return false;
                }
                if (badLeaves.contains(at)) {
                    return false;
                }
                if (GaeanKeystone.this.visitLeaves(at, contig, badLeaves) && contig.size() < MAX_PORTAL_SIZE) {
                    return true;
                }
                badLeaves.addAll(contig);
                contig.clear();
                return false;
            }
        });
        if (contig.isEmpty()) {
            return false;
        }
        for (PCoord at : contig) {
            at.setBlockNoNotify(ModBlocks.portal);
        }
        return true;
    }

    boolean visitLeaves(PCoord start, HashSet<PCoord> contig, HashSet<PCoord> invalidLeaves) {
        ArrayList<PCoord> frontier = new ArrayList<PCoord>();
        frontier.add(start);
        while (!frontier.isEmpty()) {
            PCoord at = (PCoord)frontier.remove(frontier.size() - 1);
            for (PCoord n : at.neighbors()) {
                if (!n.isLeaf()) continue;
                if (invalidLeaves.contains(n)) {
                    return false;
                }
                if (!contig.add(n)) continue;
                if (!n.validLeafPortal()) {
                    invalidLeaves.addAll(frontier);
                    return false;
                }
                frontier.add(n);
            }
        }
        return true;
    }

    public void buildDestinationPortal(World w, int x, int y, int z) {
        PCoord keystone = new PCoord(w, x, y, z);
        while (keystone.isAir() && keystone.y > 0) {
            keystone = keystone.add(0, -1, 0);
        }
        keystone = keystone.add(0, 1, 0);
        int C = 5;
        int r = 2;
        PCoord floorMin = keystone.add(-r, -1, -r);
        PCoord floorMax = keystone.add(r, -1, r);
        PCoord.iterateCube(floorMin, floorMax, new PCoord.ICoordFunc(){

            @Override
            public boolean visit(PCoord at) {
                at.ensureFloored();
                int yMin = at.y + 1;
                int yMax = at.y + 5;
                for (int y = yMin; y < yMax; ++y) {
                    at.w.func_147468_f(at.x, y, at.z);
                }
                return false;
            }
        });
        PCoord start = floorMin.add(0, 1, 0);
        int dx = 0;
        int dy = 0;
        int dz = 0;
        for (byte b : portalFrame) {
            if (b == -1) {
                ++dy;
                dx = 0;
                continue;
            }
            if (b == 1 || b == 2) {
                Object block;
                int md = 0;
                if (b == 2) {
                    block = w.field_73013_u != EnumDifficulty.HARD ? Blocks.field_150362_t : Blocks.field_150350_a;
                } else {
                    md = w.field_73012_v.nextBoolean() ? 5 : 6;
                    block = ModBlocks.umberstone;
                }
                w.func_147465_d(start.x + dx, start.y + dy, start.z + dz, (Block)block, md, 3);
            }
            ++dx;
        }
        keystone.setBlock(ModBlocks.gaeanKeystone);
        keystone.w.func_147438_o(keystone.x, keystone.y, keystone.z);
    }

    static class PCoord {
        final World w;
        final int x;
        final int y;
        final int z;

        PCoord(World w, int x, int y, int z) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        PCoord add(int dx, int dy, int dz) {
            return new PCoord(this.w, this.x + dx, this.y + dy, this.z + dz);
        }

        boolean is(Block b) {
            return this.w.func_147439_a(this.x, this.y, this.z) == b;
        }

        static void iterateCube(PCoord min, PCoord max, ICoordFunc func) {
            for (int x = min.x; x <= max.x; ++x) {
                for (int z = min.z; z <= max.z; ++z) {
                    for (int y = min.y; y <= max.y; ++y) {
                        if (!func.visit(new PCoord(min.w, x, y, z))) continue;
                        return;
                    }
                }
            }
        }

        public void setAir() {
            this.w.func_147468_f(this.x, this.y, this.z);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PCoord)) {
                return false;
            }
            PCoord pCoord = (PCoord)o;
            if (this.x != pCoord.x) {
                return false;
            }
            if (this.y != pCoord.y) {
                return false;
            }
            if (this.z != pCoord.z) {
                return false;
            }
            return !(this.w == null ? pCoord.w != null : !this.w.equals(pCoord.w));
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        boolean isLeaf() {
            return this.w.func_147439_a(this.x, this.y, this.z) instanceof BlockLeaves;
        }

        boolean validLeafPortal() {
            return ErebusPortal.obeysPortalRule(this.w, this.x, this.y, this.z, false);
        }

        PCoord[] neighbors() {
            PCoord[] ret = new PCoord[6];
            int i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                ret[i++] = this.add(dir.offsetX, dir.offsetY, dir.offsetZ);
            }
            return ret;
        }

        public void ensureFloored() {
            Block b = this.w.func_147439_a(this.x, this.y, this.z);
            if (b.isReplaceable((IBlockAccess)this.w, this.x, this.y, this.z)) {
                this.setBlock(ModBlocks.umberstone);
            }
        }

        public void setBlock(Block b) {
            this.w.func_147449_b(this.x, this.y, this.z, b);
        }

        public void setBlockNoNotify(Block b) {
            this.w.func_147465_d(this.x, this.y, this.z, b, 0, 2);
        }

        public boolean isAir() {
            return this.w.func_147437_c(this.x, this.y, this.z);
        }

        static interface ICoordFunc {
            public boolean visit(PCoord var1);
        }
    }
}

