/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.bamboo;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.item.ItemMaterials;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.EnumPlantType;

public class BlockBambooShoot
extends BlockFlower
implements IGrowable {
    private static Map<Block, Float> soilValues = new HashMap<Block, Float>();

    public static byte calculateBambooHappiness(World world, int x, int y, int z, Block block) {
        double happiness = 0.0;
        int bottomY = y;
        while (world.func_147439_a(x, --bottomY, z) == block) {
        }
        ++bottomY;
        BiomeGenBase biome = world.func_72807_a(x, z);
        boolean canSeeSun = world.func_72937_j(x, y, z);
        if (biome == BiomeGenBase.field_76778_j) {
            happiness -= 8.0;
        } else if (biome.field_76750_F >= 2.0f) {
            happiness -= 6.0;
        } else if (biome.field_76750_F >= 1.4f && biome.field_76750_F < 2.0f) {
            happiness += canSeeSun ? -2.0 : 5.0;
        } else if (biome.field_76750_F >= 0.9f && biome.field_76750_F < 1.4f) {
            happiness += canSeeSun ? 2.0 : 6.0;
        } else if (biome.field_76750_F >= 0.7f && biome.field_76750_F < 0.9f) {
            happiness += canSeeSun ? 4.0 : 1.0;
        } else if (biome.field_76750_F >= 0.3f && biome.field_76750_F < 0.7f) {
            happiness += canSeeSun ? 4.0 : -2.0;
        } else if (biome.field_76750_F >= 0.1f && biome.field_76750_F < 0.3f) {
            happiness -= canSeeSun ? 8.0 : 4.0;
        } else if (biome.field_76750_F < 0.1f) {
            happiness -= canSeeSun ? 16.0 : 10.0;
        }
        happiness += biome.func_76738_d() ? 4.0 : -2.0;
        int perfectWaterAmount = (int)Math.floor(35.0 * (Math.pow((double)biome.field_76750_F + 1.0, 2.0) / 4.0) * (biome.func_76738_d() ? 1.0 : 1.75));
        double waterFound = 0.0;
        for (int a = 0; a < 150; ++a) {
            int xx = x + world.field_73012_v.nextInt(10) - 5;
            int zz = z + world.field_73012_v.nextInt(10) - 5;
            if (world.func_147439_a(xx, bottomY + world.field_73012_v.nextInt(4) - 2, zz).func_149688_o() != Material.field_151586_h) continue;
            waterFound += 8.0 - Math.sqrt(Math.pow(xx - x, 2.0) + Math.pow(zz - z, 2.0));
        }
        happiness += (5.5 - 0.25 * Math.abs(waterFound - (double)perfectWaterAmount)) * 0.8;
        Float soilValue = soilValues.get(world.func_147439_a(x, bottomY - 1, z));
        if (soilValue != null) {
            happiness *= (double)soilValue.floatValue();
        }
        return (byte)Math.floor(Math.min(22.0, Math.max(-22.0, happiness)));
    }

    public BlockBambooShoot() {
        super(0);
        this.func_149675_a(true);
        float f = 0.2f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 3.5f, 0.5f + f);
        this.func_149647_a(null);
        this.func_149663_c("erebus.bambooShoot");
        this.func_149658_d("erebus:bambooShoot");
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, rand);
            byte happiness = BlockBambooShoot.calculateBambooHappiness(world, x, y, z, (Block)this);
            if (rand.nextInt(5) <= 1 && happiness > rand.nextInt(35)) {
                int meta = world.func_72805_g(x, y, z);
                world.func_147465_d(x, y, z, ModBlocks.bambooCrop, (meta >= 8 ? 8 : 0) + (int)Math.min(7.0, 2.0 + (double)happiness / 7.0 + (meta >= 8 ? 0.5 : 0.0) + Math.abs(((double)happiness / 10.0 + (meta >= 8 ? 0.6 : 0.0)) * rand.nextGaussian())), 3);
            }
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block soil = world.func_147439_a(x, y - 1, z);
        return soil != null && soilValues.containsKey(soil);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return ModItems.materials;
    }

    public int func_149692_a(int meta) {
        return ItemMaterials.DATA.BAMBOO_SHOOT.ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return ModItems.materials;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item));
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        return true;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 7) {
            world.func_72921_c(x, y, z, meta + 9, 4);
        }
    }

    static {
        soilValues.put(Blocks.field_150346_d, Float.valueOf(1.0f));
        soilValues.put((Block)Blocks.field_150349_c, Float.valueOf(1.0f));
        soilValues.put(Blocks.field_150435_aG, Float.valueOf(0.75f));
        soilValues.put((Block)Blocks.field_150354_m, Float.valueOf(0.4f));
    }
}

