/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModTabs;
import erebus.lib.EnumWood;
import erebus.world.feature.tree.WorldGenAsperTree;
import erebus.world.feature.tree.WorldGenBaobabTree;
import erebus.world.feature.tree.WorldGenCypressTree;
import erebus.world.feature.tree.WorldGenErebusHugeTree;
import erebus.world.feature.tree.WorldGenEucalyptusTree;
import erebus.world.feature.tree.WorldGenMarshwoodTree;
import erebus.world.feature.tree.WorldGenMossbarkTree;
import erebus.world.feature.tree.WorldGenSapTree;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockSaplingErebus
extends BlockSapling {
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;
    private final EnumWood wood;

    public BlockSaplingErebus(EnumWood wood) {
        this.wood = wood;
        this.func_149647_a(ModTabs.plants);
        this.func_149672_a(Block.field_149779_h);
        this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.8f, 0.9f);
        this.func_149663_c("erebus.sapling." + wood.name());
        this.func_149658_d("erebus:sapling_" + wood.name().toLowerCase());
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)("tile.erebus.sapling_" + this.wood.getUnlocalisedName() + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N());
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block soil = world.func_147439_a(x, y - 1, z);
        return soil != null && soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, rand);
            if (rand.nextInt(13 - (world.func_72957_l(x, y + 1, z) >> 1)) == 0) {
                this.growTree(world, x, y, z, rand);
            }
        }
    }

    public void func_149879_c(World world, int x, int y, int z, Random rand) {
    }

    public void func_149878_d(World world, int x, int y, int z, Random rand) {
        this.growTree(world, x, y, z, rand);
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        this.growTree(world, x, y, z, rand);
    }

    private void growTree(World world, int x, int y, int z, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (int)x, (int)y, (int)z)) {
            return;
        }
        WorldGenerator worldGen = null;
        switch (this.wood) {
            case Eucalyptus: {
                worldGen = new WorldGenEucalyptusTree();
                break;
            }
            case Baobab: {
                worldGen = new WorldGenBaobabTree();
                break;
            }
            case Asper: {
                worldGen = new WorldGenAsperTree();
                break;
            }
            case Cypress: {
                worldGen = new WorldGenCypressTree();
                break;
            }
            case Mahogany: {
                worldGen = new WorldGenErebusHugeTree(true, true, this.wood);
                ((WorldGenErebusHugeTree)worldGen).prepare(20 + rand.nextInt(5));
                break;
            }
            case Sap: {
                worldGen = new WorldGenSapTree();
                break;
            }
            case Mossbark: {
                worldGen = new WorldGenMossbarkTree();
                break;
            }
            case Marshwood: {
                worldGen = new WorldGenMarshwoodTree();
                break;
            }
        }
        if (worldGen == null) {
            return;
        }
        world.func_147468_f(x, y, z);
        if (!worldGen.func_76484_a(world, rand, x, y, z)) {
            world.func_147449_b(x, y, z, (Block)this);
        }
    }

    public boolean isSameSapling(World world, int x, int y, int z, int meta) {
        return world.func_147439_a(x, y, z) == this;
    }
}

