/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.core.helper.Utils;
import erebus.core.proxy.ClientProxy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

@SideOnly(value=Side.CLIENT)
public class BlockPlantedFlowerRender
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(block.func_149677_c(renderer.field_147845_a, x, y, z));
        int colour = block.func_149720_d(renderer.field_147845_a, x, y, z);
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float r2 = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float g2 = (r * 30.0f + g * 70.0f) / 100.0f;
            float b2 = (r * 30.0f + b * 70.0f) / 100.0f;
            r = r2;
            g = g2;
            b = b2;
        }
        tess.func_78386_a(r, g, b);
        this.drawFlower(world.func_72805_g(x, y, z), x, y, z);
        return true;
    }

    private void setPetalColour(int meta) {
        Tessellator tess = Tessellator.field_78398_a;
        float[] colour = EntitySheep.field_70898_d[BlockColored.func_150032_b((int)Utils.getFlowerMetadata(meta))];
        tess.func_78386_a(colour[0], colour[1], colour[2]);
    }

    private void drawFlower(int meta, int x, int y, int z) {
        this.drawCrossedSquares(ModBlocks.flowerPlanted.func_149691_a(0, meta), x, y, z);
        this.setPetalColour(meta);
        this.drawCrossedSquares(ModBlocks.flowerPlanted.func_149691_a(1, meta), x, y, z);
    }

    private void drawCrossedSquares(IIcon icon, int x, int y, int z) {
        Tessellator tess = Tessellator.field_78398_a;
        double minU = icon.func_94209_e();
        double minV = icon.func_94206_g();
        double maxU = icon.func_94212_f();
        double maxV = icon.func_94210_h();
        double minX = (double)x + 0.05;
        double maxX = (double)x + 0.95;
        double minZ = (double)z + 0.05;
        double maxZ = (double)z + 0.95;
        tess.func_78374_a(minX, (double)((float)y + 1.0f), minZ, minU, minV);
        tess.func_78374_a(minX, (double)y + 0.0, minZ, minU, maxV);
        tess.func_78374_a(maxX, (double)y + 0.0, maxZ, maxU, maxV);
        tess.func_78374_a(maxX, (double)((float)y + 1.0f), maxZ, maxU, minV);
        tess.func_78374_a(maxX, (double)((float)y + 1.0f), maxZ, minU, minV);
        tess.func_78374_a(maxX, (double)y + 0.0, maxZ, minU, maxV);
        tess.func_78374_a(minX, (double)y + 0.0, minZ, maxU, maxV);
        tess.func_78374_a(minX, (double)((float)y + 1.0f), minZ, maxU, minV);
        tess.func_78374_a(minX, (double)((float)y + 1.0f), maxZ, minU, minV);
        tess.func_78374_a(minX, (double)y + 0.0, maxZ, minU, maxV);
        tess.func_78374_a(maxX, (double)y + 0.0, minZ, maxU, maxV);
        tess.func_78374_a(maxX, (double)((float)y + 1.0f), minZ, maxU, minV);
        tess.func_78374_a(maxX, (double)((float)y + 1.0f), minZ, minU, minV);
        tess.func_78374_a(maxX, (double)y + 0.0, minZ, minU, maxV);
        tess.func_78374_a(minX, (double)y + 0.0, maxZ, maxU, maxV);
        tess.func_78374_a(minX, (double)((float)y + 1.0f), maxZ, maxU, minV);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ClientProxy.BlockRenderIDs.PLANTED_FLOWER.id();
    }
}

