/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BambooTorchItemRenderer
implements IItemRenderer {
    private final RenderBlocks blockRenderer = new RenderBlocks();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderTorch(0.0f, 0.5f, 0.0f, 1.0);
                break;
            }
            case EQUIPPED: {
                this.renderEquipped(0.7f, 0.7f, 0.7f, 1.0);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderTorchFirstPerson(0.5f, 0.9f, 0.5f, 1.0);
                break;
            }
            case INVENTORY: {
                this.renderTorchInventory(0.0f, -0.45f, 0.0f, 0.75);
                break;
            }
        }
    }

    private void renderEquipped(float x, float y, float z, double size) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 0, 1.0f);
        GL11.glTranslatef((float)(x - 0.7f), (float)(y + 0.3f), (float)(z - 0.7f));
        this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 1, 1.0f);
        GL11.glPopMatrix();
    }

    private void renderTorch(float x, float y, float z, double size) {
        if (RenderItem.field_82407_g) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)(y - 0.625f), (float)z);
            GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
            this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 0, 1.0f);
            GL11.glTranslatef((float)x, (float)y, (float)z);
            this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 1, 1.0f);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glScaled((double)size, (double)size, (double)size);
            this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 0, 1.0f);
            GL11.glTranslatef((float)x, (float)y, (float)z);
            this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 1, 1.0f);
            GL11.glPopMatrix();
        }
    }

    private void renderTorchFirstPerson(float x, float y, float z, double size) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 0, 1.0f);
        GL11.glTranslatef((float)(x - 0.5f), (float)(y + 0.1f), (float)(z - 0.5f));
        this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 1, 1.0f);
        GL11.glPopMatrix();
    }

    private void renderTorchInventory(float x, float y, float z, double size) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 0, 1.0f);
        GL11.glTranslatef((float)x, (float)(y + 1.4f), (float)z);
        this.blockRenderer.func_147800_a(ModBlocks.bambooTorch, 1, 1.0f);
        GL11.glPopMatrix();
    }
}

