/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.handler;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import erebus.ModBlocks;
import erebus.core.handler.ErebusExtendedPlayerProperties;
import erebus.core.helper.Utils;
import erebus.tileentity.TileEntityBones;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;

public class EntityDeathInventoryHandler {
    private static final List<OffsetPos> offsets = new LinkedList<OffsetPos>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrops(PlayerDropsEvent event) {
        ArrayList drops = event.drops;
        if (drops.isEmpty()) {
            return;
        }
        World world = event.entityLiving.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (event.entityLiving instanceof EntityPlayer && !world.func_82736_K().func_82766_b("keepInventory")) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            ErebusExtendedPlayerProperties playerProps = ErebusExtendedPlayerProperties.get(player);
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)(player.field_70163_u - 1.0));
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            int playerFacing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int directionMeta = 0;
            for (OffsetPos offset : offsets) {
                if (!world.func_147439_a(x + offset.x, y + offset.y, z + offset.z).isReplaceable((IBlockAccess)world, x + offset.x, y + offset.y, z + offset.z)) continue;
                x += offset.x;
                y += offset.y;
                z += offset.z;
                break;
            }
            if (playerFacing == 0) {
                directionMeta = 2;
            }
            if (playerFacing == 1) {
                directionMeta = 5;
            }
            if (playerFacing == 2) {
                directionMeta = 3;
            }
            if (playerFacing == 3) {
                directionMeta = 4;
            }
            world.func_147465_d(x, y, z, ModBlocks.bones, directionMeta, 3);
            playerProps.setDimension(player.field_70170_p.field_73011_w.func_80007_l());
            playerProps.setXLocation(x);
            playerProps.setZLocation(z);
            NBTTagCompound playerData = new NBTTagCompound();
            playerProps.saveNBTData(playerData);
            TileEntityBones tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBones.class);
            if (tile != null) {
                int index = 0;
                for (int i = 0; i < drops.size() && index < 86 && index < drops.size(); ++i) {
                    ItemStack stack;
                    EntityItem entityitem;
                    if ((entityitem = (EntityItem)drops.get(index++)) == null || (stack = entityitem.func_92059_d()) == null) continue;
                    tile.func_70299_a(i, stack.func_77946_l());
                    entityitem.func_70106_y();
                }
                tile.setOwner("R.I.P. " + player.func_70005_c_());
            }
        }
    }

    static {
        offsets.add(new OffsetPos(0, 0, 0));
        offsets.add(new OffsetPos(0, 1, 0));
        offsets.add(new OffsetPos(0, -1, 0));
        offsets.add(new OffsetPos(1, 0, 0));
        offsets.add(new OffsetPos(1, 0, 1));
        offsets.add(new OffsetPos(-1, 0, 1));
        offsets.add(new OffsetPos(-1, 0, -1));
        offsets.add(new OffsetPos(1, 1, 0));
        offsets.add(new OffsetPos(1, 1, 1));
        offsets.add(new OffsetPos(-1, 1, 1));
        offsets.add(new OffsetPos(-1, 1, -1));
        offsets.add(new OffsetPos(1, -1, 0));
        offsets.add(new OffsetPos(1, -1, 1));
        offsets.add(new OffsetPos(-1, -1, 1));
        offsets.add(new OffsetPos(-1, -1, -1));
    }

    static class OffsetPos {
        final int x;
        final int y;
        final int z;

        OffsetPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

