/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.handler.configs;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import erebus.Erebus;
import erebus.ModBiomes;
import erebus.preserved.PreservableEntityRegistry;
import erebus.world.biomes.decorators.data.OreSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    private File configFolder;
    public Configuration config;
    public int erebusDimensionID;
    public int portalCooldown;
    public int antlionMazeFrequency;
    public int mobAttackDamageMultiplier;
    public int mobHealthMultipier;
    public byte beetleLarvaEating = 0;
    public boolean spawnPortalMobs;
    public boolean bombardierBlockDestroy;
    public boolean randomNames;
    public boolean playCustomSongs;
    public boolean alternativePlanks;
    public boolean graveMarker;
    public boolean bioluminescence;
    public boolean glowshrooms;
    public boolean generateVents;
    public boolean allowRespawning;
    public boolean netherWidows;
    public boolean biomeFogColours;
    public boolean disableThaumcraft = false;
    public boolean disableFMP = false;
    public final String[] usedCategories = new String[]{"general", "Biomes", "Ores", "Integration", "Mob Modifiers"};

    public void loadConfig(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        this.configFolder = configFile.getParentFile();
        this.config = new Configuration(configFile);
        this.config.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        this.readEntityDimensionsFile();
        ModBiomes.undergroundJungleID = this.config.get("Biomes", "Underground Jungle", ModBiomes.undergroundJungleID).getInt(ModBiomes.undergroundJungleID);
        ModBiomes.volcanicDesertID = this.config.get("Biomes", "Volcanic Desert", ModBiomes.volcanicDesertID).getInt(ModBiomes.volcanicDesertID);
        ModBiomes.subterraneanSavannahID = this.config.get("Biomes", "Subterranean Savannah", ModBiomes.subterraneanSavannahID).getInt(ModBiomes.subterraneanSavannahID);
        ModBiomes.elysianFieldsID = this.config.get("Biomes", "Elysian Fields", ModBiomes.elysianFieldsID).getInt(ModBiomes.elysianFieldsID);
        ModBiomes.ulteriorOutbackID = this.config.get("Biomes", "Ulterior Outback", ModBiomes.ulteriorOutbackID).getInt(ModBiomes.ulteriorOutbackID);
        ModBiomes.fungalForestID = this.config.get("Biomes", "Fungal Forest", ModBiomes.fungalForestID).getInt(ModBiomes.fungalForestID);
        ModBiomes.fieldsSubForestID = this.config.get("Biomes", "Fields - Forest", ModBiomes.fieldsSubForestID).getInt(ModBiomes.fieldsSubForestID);
        ModBiomes.submergedSwampID = this.config.get("Biomes", "Submerged Swamp", ModBiomes.submergedSwampID).getInt(ModBiomes.submergedSwampID);
        this.erebusDimensionID = this.config.get("general", "Dimension ID of The Erebus", 66, "There doesn't appear to be a limit on dimension IDs, but try to keep it low").getInt(66);
        this.portalCooldown = this.config.get("general", "Number of seconds before the portal is usable again.", 5).getInt(5);
        this.antlionMazeFrequency = this.config.get("general", "Antlion Maze Frequency lower numbers increase rate. May Cause issues if too low.", 1024).getInt(1024);
        this.allowRespawning = this.config.get("general", "Should player re-spawn in dimension", false).getBoolean(false);
        this.spawnPortalMobs = this.config.get("general", "Should spawn beetles and larvae in the portal", true).getBoolean(true);
        this.beetleLarvaEating = (byte)this.config.get("general", "Beetle larva eating settings", 0, "0 = only wooden blocks except tile entities & logs, 1 = only wooden blocks except logs, 2 = anything", 0, 2).getInt(0);
        this.bombardierBlockDestroy = this.config.get("general", "Bombardier Beetle Block destruction", true, "This will not stop block destruction for player attacks only collided with blocks!").getBoolean(true);
        this.randomNames = this.config.get("general", "Random mob names", true).getBoolean(true);
        this.playCustomSongs = this.config.get("general", "Play erebus songs", true).getBoolean(true);
        this.alternativePlanks = this.config.get("general", "Alternative Planks Textures", false).getBoolean(false);
        this.graveMarker = this.config.get("general", "Block O' Bones Inventory Save", true).getBoolean(true);
        this.biomeFogColours = this.config.get("general", "Coloured Biome Fogs", true).getBoolean(true);
        this.bioluminescence = this.config.get("general", "Glowing bugs emit light", true).getBoolean(true);
        this.glowshrooms = this.config.get("general", "Add Glowshrooms to World generation", true).getBoolean(true);
        this.generateVents = this.config.get("general", "Generate natural swap vents", true).getBoolean(true);
        this.netherWidows = this.config.get("general", "Spawn Black Widows in Nether", true).getBoolean(true);
        this.mobAttackDamageMultiplier = this.config.get("Mob Modifiers", "Mob Attack Damage Multipier", 1).getInt(1);
        this.mobHealthMultipier = this.config.get("Mob Modifiers", "Mob Health Multiplier", 1).getInt(1);
        this.disableThaumcraft = this.config.get("Integration", "Disable Thaumcraft integration", false).getBoolean(false);
        this.disableFMP = this.config.get("Integration", "Disable Forge Multipart integration", false).getBoolean(false);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void initOreConfigs() {
        for (OreSettings.OreType oretype : OreSettings.OreType.values()) {
            oretype.setEnabled(this.config.get("Ores", "Generate " + oretype.toString().toLowerCase(), oretype.isEnabled()).getBoolean(oretype.isEnabled()));
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void readEntityDimensionsFile() {
        File file = new File(this.configFolder, "ErebusEntityDimensions.cfg");
        BufferedReader br = new BufferedReader(new InputStreamReader(Erebus.class.getResourceAsStream("/assets/DefaultEntityDimensions.cfg")));
        if (!file.exists()) {
            PreservableEntityRegistry.INSTANCE.readFile(br, true);
            PreservableEntityRegistry.INSTANCE.writeConfigFile(file);
        } else {
            try {
                PreservableEntityRegistry.INSTANCE.readFile(br, true);
                PreservableEntityRegistry.INSTANCE.readFile(new BufferedReader(new FileReader(file)), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("erebus".equals(event.modID)) {
            this.syncConfigs();
            this.initOreConfigs();
        }
    }
}

