/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.proxy;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import erebus.block.BlockPetrifiedChest;
import erebus.block.silo.TileEntitySiloTank;
import erebus.entity.EntityAnimatedBambooCrate;
import erebus.entity.EntityBlackAnt;
import erebus.inventory.ContainerAnimatedBambooCrate;
import erebus.inventory.ContainerAntInventory;
import erebus.inventory.ContainerBambooCrate;
import erebus.inventory.ContainerColossalCrate;
import erebus.inventory.ContainerComposter;
import erebus.inventory.ContainerExtenderThingy;
import erebus.inventory.ContainerHoneyComb;
import erebus.inventory.ContainerPetrifiedCraftingTable;
import erebus.inventory.ContainerPetrifiedWoodChest;
import erebus.inventory.ContainerSilo;
import erebus.inventory.ContainerSmoothieMaker;
import erebus.inventory.ContainerUmberFurnace;
import erebus.tileentity.TileEntityAntlionEgg;
import erebus.tileentity.TileEntityArmchair;
import erebus.tileentity.TileEntityBambooBridge;
import erebus.tileentity.TileEntityBambooCrate;
import erebus.tileentity.TileEntityBambooPole;
import erebus.tileentity.TileEntityBones;
import erebus.tileentity.TileEntityCompletedPuzzle;
import erebus.tileentity.TileEntityComposter;
import erebus.tileentity.TileEntityErebusAltar;
import erebus.tileentity.TileEntityErebusAltarEmpty;
import erebus.tileentity.TileEntityErebusAltarHealing;
import erebus.tileentity.TileEntityErebusAltarLightning;
import erebus.tileentity.TileEntityErebusAltarRepair;
import erebus.tileentity.TileEntityErebusAltarXP;
import erebus.tileentity.TileEntityExtenderThingy;
import erebus.tileentity.TileEntityGaeanKeystone;
import erebus.tileentity.TileEntityGlowGem;
import erebus.tileentity.TileEntityGlowingJar;
import erebus.tileentity.TileEntityHoneyComb;
import erebus.tileentity.TileEntityJarOHoney;
import erebus.tileentity.TileEntityLadder;
import erebus.tileentity.TileEntityOfferingAltar;
import erebus.tileentity.TileEntityPetrifiedWoodChest;
import erebus.tileentity.TileEntityPreservedBlock;
import erebus.tileentity.TileEntityPuffShroom;
import erebus.tileentity.TileEntitySlidingBlockPuzzle;
import erebus.tileentity.TileEntitySmoothieMaker;
import erebus.tileentity.TileEntitySoldierAntTrap;
import erebus.tileentity.TileEntityTarantulaEgg;
import erebus.tileentity.TileEntityTempleTeleporter;
import erebus.tileentity.TileEntityUmberFurnace;
import erebus.tileentity.TileEntityUmberGolemStatue;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CommonProxy
implements IGuiHandler {
    public final int[][] places = new int[][]{{1, 0, 0}, {1, 0, 1}, {0, 0, 1}, {1, 1, 0}, {1, 1, 1}, {0, 1, 1}, {0, 1, 0}, {0, 0, 0}};

    public void registerKeyHandlers() {
    }

    public void registerRenderInformation() {
    }

    public void registerTileEntities() {
        this.registerTileEntity(TileEntityBambooCrate.class, "bambooCrate");
        this.registerTileEntity(TileEntityUmberFurnace.class, "umberFurnace");
        this.registerTileEntity(TileEntityErebusAltar.class, "bugZapper");
        this.registerTileEntity(TileEntityErebusAltarEmpty.class, "altarEmpty");
        this.registerTileEntity(TileEntityErebusAltarHealing.class, "altarHealing");
        this.registerTileEntity(TileEntityErebusAltarLightning.class, "altarLighting");
        this.registerTileEntity(TileEntityErebusAltarRepair.class, "altarRepair");
        this.registerTileEntity(TileEntityErebusAltarXP.class, "altarXP");
        this.registerTileEntity(TileEntityGlowingJar.class, "glowingJar");
        this.registerTileEntity(TileEntityLadder.class, "bambooLadder");
        this.registerTileEntity(TileEntityBambooBridge.class, "bambooBridge");
        this.registerTileEntity(TileEntityUmberGolemStatue.class, "umberGolemStatue");
        this.registerTileEntity(TileEntityPetrifiedWoodChest.class, "petrifiedWoodChest");
        this.registerTileEntity(TileEntityBones.class, "blockOBones");
        this.registerTileEntity(TileEntityExtenderThingy.class, "extenderThingy");
        this.registerTileEntity(TileEntityBambooPole.class, "bambooPole");
        this.registerTileEntity(TileEntityJarOHoney.class, "jarOHoney");
        this.registerTileEntity(TileEntityGlowGem.class, "glowGemBlock");
        this.registerTileEntity(TileEntityHoneyComb.class, "honeyComb");
        this.registerTileEntity(TileEntitySiloTank.class, "siloTank");
        this.registerTileEntity(TileEntityComposter.class, "composter");
        this.registerTileEntity(TileEntityGaeanKeystone.class, "gaeanKeystone");
        this.registerTileEntity(TileEntityOfferingAltar.class, "offeringAltar");
        this.registerTileEntity(TileEntityTarantulaEgg.class, "tarantulaEgg");
        this.registerTileEntity(TileEntitySmoothieMaker.class, "smoothieMaker");
        this.registerTileEntity(TileEntityTempleTeleporter.class, "templeTeleporter");
        this.registerTileEntity(TileEntityAntlionEgg.class, "antlionEgg");
        this.registerTileEntity(TileEntityPreservedBlock.class, "preservedBlock");
        this.registerTileEntity(TileEntitySoldierAntTrap.class, "soldierAntTrap");
        this.registerTileEntity(TileEntitySlidingBlockPuzzle.class, "slidingBlockPuzzle");
        this.registerTileEntity(TileEntityPuffShroom.class, "puffShroom");
        this.registerTileEntity(TileEntityCompletedPuzzle.class, "completedPuzzle");
        this.registerTileEntity(TileEntityArmchair.class, "armchair");
    }

    private void registerTileEntity(Class<? extends TileEntity> cls, String baseName) {
        GameRegistry.registerTileEntity(cls, (String)("tile.erebus." + baseName));
    }

    public void spawnCustomParticle(String particleName, World world, double x, double y, double z, double vecX, double vecY, double vecZ) {
    }

    public Container getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        GuiID guiID = GuiID.values()[ID];
        TileEntity tile = world.func_147438_o(x, y, z);
        Entity entity = world.func_73045_a(x);
        switch (guiID) {
            case ANIMATED_BAMBOO_CRATE: {
                if (entity != null && entity instanceof EntityAnimatedBambooCrate) {
                    return new ContainerAnimatedBambooCrate(player.field_71071_by, (EntityAnimatedBambooCrate)entity);
                }
            }
            case ANT_INVENTORY: {
                if (entity != null && entity instanceof EntityBlackAnt) {
                    return new ContainerAntInventory(player.field_71071_by, (EntityBlackAnt)entity);
                }
            }
            case BAMBOO_CRATE: {
                return new ContainerBambooCrate(player.field_71071_by, (TileEntityBambooCrate)tile);
            }
            case COLOSSAL_CRATE: {
                ArrayList<TileEntityBambooCrate> list = new ArrayList<TileEntityBambooCrate>();
                for (int[] place : this.places) {
                    TileEntity te = world.func_147438_o(x + place[0], y + place[1], z + place[2]);
                    if (te == null || !(te instanceof TileEntityBambooCrate)) {
                        return null;
                    }
                    list.add((TileEntityBambooCrate)te);
                }
                return new ContainerColossalCrate(player.field_71071_by, list);
            }
            case COMPOSTER: {
                return new ContainerComposter(player.field_71071_by, (TileEntityComposter)tile);
            }
            case EXTENDER_THINGY: {
                return new ContainerExtenderThingy(player.field_71071_by, (TileEntityExtenderThingy)world.func_147438_o(x, y, z));
            }
            case HONEY_COMB: {
                return new ContainerHoneyComb(player.field_71071_by, (TileEntityHoneyComb)tile);
            }
            case PETRIFIED_CHEST: {
                IInventory inventory = BlockPetrifiedChest.getInventory(world, x, y, z);
                return new ContainerPetrifiedWoodChest((IInventory)player.field_71071_by, inventory);
            }
            case PETRIFIED_CRAFT: {
                return new ContainerPetrifiedCraftingTable(player.field_71071_by, world, x, y, z);
            }
            case SILO_INVENTORY: {
                return new ContainerSilo(player.field_71071_by, (TileEntitySiloTank)tile);
            }
            case SMOOTHIE_MAKER: {
                return new ContainerSmoothieMaker(player.field_71071_by, (TileEntitySmoothieMaker)tile);
            }
            case UMBER_FURNACE: {
                return new ContainerUmberFurnace(player.field_71071_by, (TileEntityUmberFurnace)tile);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public World getClientWorld() {
        return null;
    }

    public EntityPlayer getClientPlayer() {
        return null;
    }

    public static enum GuiID {
        BAMBOO_CRATE,
        COLOSSAL_CRATE,
        PETRIFIED_CRAFT,
        UMBER_FURNACE,
        PETRIFIED_CHEST,
        ANIMATED_BAMBOO_CRATE,
        EXTENDER_THINGY,
        HONEY_COMB,
        ANT_INVENTORY,
        SILO_INVENTORY,
        COMPOSTER,
        SMOOTHIE_MAKER;

    }
}

