/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityBotFly;
import erebus.entity.EntityFly;
import erebus.entity.EntityMidgeSwarm;
import erebus.entity.EntityWebSling;
import erebus.item.ItemMaterials;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityBlackWidow
extends EntityMob {
    private int shouldDo;
    Class<?>[] preys = new Class[]{EntityFly.class, EntityBotFly.class, EntityMidgeSwarm.class};

    public EntityBlackWidow(World world) {
        super(world);
        int i = 1 << this.field_70146_Z.nextInt(3);
        this.setWidowSize(i);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(1));
    }

    protected void setWidowSize(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)new Byte((byte)par1));
        this.func_70105_a(0.9f * (float)par1, 0.4f * (float)par1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 25.0 : 25.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected Entity func_70782_k() {
        EntityPlayer var1 = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return var1;
    }

    protected Entity findEnemyToAttack() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(8.0, 10.0, 8.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityLivingBase)) continue;
            for (int j = 0; j < this.preys.length; ++j) {
                if (entity.getClass() != this.preys[j]) continue;
                return entity;
            }
        }
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            int i = this.getWidowSize();
            this.func_70105_a(0.9f * (float)i, 0.4f * (float)i);
        }
        this.field_70789_a = this.func_70782_k() != null ? this.func_70782_k() : (this.findEnemyToAttack() != null ? this.findEnemyToAttack() : null);
        if (!this.field_70170_p.field_72995_K && this.getWidowSize() == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 1.0 : 1.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        }
        if (!this.field_70170_p.field_72995_K && this.getWidowSize() == 2) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 20.0 : 20.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 1.5 : 1.5 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        }
        if (!this.field_70170_p.field_72995_K && this.getWidowSize() == 4) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 25.0 : 25.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public int func_70641_bl() {
        return 2;
    }

    protected void func_70069_a(float distance) {
    }

    public void func_70110_aj() {
    }

    public boolean isClimbing() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        return potionEffect.func_76456_a() == Potion.field_76436_u.field_76415_H ? false : super.func_70687_e(potionEffect);
    }

    protected String func_70639_aQ() {
        return "erebus:blackwidowsound";
    }

    protected String func_70621_aR() {
        return "erebus:blackwidowhurt";
    }

    protected String func_70673_aS() {
        return "erebus:squish";
    }

    protected String getWebSlingThrowSound() {
        return "erebus:webslingthrow";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean attackedByPlayer, int looting) {
        super.func_70628_a(attackedByPlayer, looting);
        if (attackedByPlayer && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
        this.func_70099_a(ItemMaterials.DATA.POISON_GLAND.makeStack(1 + this.field_70146_Z.nextInt(2)), 0.0f);
    }

    protected void func_70785_a(Entity entity, float distance) {
        int i = this.getWidowSize();
        if (distance < 0.9f * (float)i) {
            super.func_70785_a(entity, distance);
            this.func_70652_k(entity);
        }
        if (distance > 2.0f && distance < 6.0f && this.field_70146_Z.nextInt(10) == 0 && this.field_70122_E) {
            double d0 = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w = d0 / (double)f2 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
            this.field_70179_y = d1 / (double)f2 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
            this.field_70181_x = 0.4f;
        }
        if (distance >= 5.0f & distance < 8.0f && this.field_70724_aR == 0) {
            ++this.shouldDo;
            if (this.shouldDo == 1) {
                this.field_70724_aR = 60;
            } else if (this.shouldDo <= 4) {
                this.field_70724_aR = 6;
            } else {
                this.field_70724_aR = 20;
                this.shouldDo = 0;
            }
            if (this.shouldDo > 1 && this.getWidowSize() > 1 && entity instanceof EntityPlayer) {
                this.field_70170_p.func_72956_a((Entity)this, this.getWebSlingThrowSound(), 1.0f, 1.0f);
                for (int count = 0; count < 1; ++count) {
                    EntityWebSling webSling = new EntityWebSling(this.field_70170_p, (EntityLiving)this);
                    webSling.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                    webSling.setType((byte)1);
                    this.field_70170_p.func_72838_d((Entity)webSling);
                }
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                int chanceFiftyFifty;
                int duration = 0;
                if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                    duration = 7;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                    duration = 15;
                }
                if (duration > 0 && (chanceFiftyFifty = this.field_70146_Z.nextInt(2)) == 1) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Size", this.getWidowSize() - 1);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setWidowSize(nbt.func_74762_e("Size") + 1);
    }

    public int getWidowSize() {
        return this.field_70180_af.func_75683_a(16);
    }
}

