/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.core.handler.configs.ConfigHandler;
import erebus.item.ItemMaterials;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityGlowWorm
extends EntityCreature {
    public int lastX;
    public int lastY;
    public int lastZ;
    private boolean triggerOnce;

    public EntityGlowWorm(World world) {
        super(world);
        this.field_70138_W = 0.0f;
        this.field_70178_ae = true;
        this.func_70105_a(1.5f, 0.5f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)0.7f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)new Byte(0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c(1.0f);
        if (light >= 0.0f) {
            return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 2;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected String func_70639_aQ() {
        return "erebus:glowwormsound";
    }

    protected String func_70621_aR() {
        return "erebus:glowwormhurt";
    }

    protected String func_70673_aS() {
        return "erebus:squish";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
        for (int amount = 0; amount < chance; ++amount) {
            this.func_70099_a(ItemMaterials.DATA.BIO_LUMINESCENCE.makeStack(), 0.0f);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.findNearEntity();
        }
        if (this.field_70170_p.field_72995_K && this.isGlowing()) {
            this.lightUp(this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        }
        if (this.field_70170_p.field_72995_K && !this.isGlowing()) {
            this.switchOff();
        }
        super.func_70071_h_();
    }

    @SideOnly(value=Side.CLIENT)
    private void lightUp(World world, int x, int y, int z) {
        if (!ConfigHandler.INSTANCE.bioluminescence) {
            return;
        }
        world.func_72915_b(EnumSkyBlock.Block, x, y, z, 9);
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (x + i == this.lastX && y + j == this.lastY && z + k == this.lastZ && !this.field_70128_L) continue;
                    world.func_147463_c(EnumSkyBlock.Block, this.lastX + i, this.lastY + j, this.lastZ + k);
                    this.lastX = x;
                    this.lastY = y;
                    this.lastZ = z;
                }
            }
        }
        this.triggerOnce = true;
    }

    @SideOnly(value=Side.CLIENT)
    private void switchOff() {
        if (!ConfigHandler.INSTANCE.bioluminescence) {
            return;
        }
        if (this.triggerOnce) {
            this.field_70170_p.func_147463_c(EnumSkyBlock.Block, this.lastX, this.lastY, this.lastZ);
            this.field_70170_p.func_147463_c(EnumSkyBlock.Block, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            this.triggerOnce = false;
        }
    }

    protected Entity findNearEntity() {
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 0.5), (double)(this.field_70163_u - 0.5), (double)(this.field_70161_v - 0.5), (double)(this.field_70165_t + 0.5), (double)(this.field_70163_u + 0.5), (double)(this.field_70161_v + 0.5)).func_72314_b(8.0, 8.0, 8.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || this.getIsNearEntity()) continue;
            this.setIsNearEntity(true);
        }
        if (list.isEmpty() && this.getIsNearEntity()) {
            this.setIsNearEntity(false);
        }
        return null;
    }

    public boolean isGlowing() {
        return this.field_70170_p.func_72971_b(1.0f) < 0.5f && this.getIsNearEntity();
    }

    public void setIsNearEntity(boolean entityNear) {
        this.field_70180_af.func_75692_b(30, (Object)(entityNear ? (byte)1 : 0));
    }

    public boolean getIsNearEntity() {
        return this.field_70180_af.func_75683_a(30) == 1;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.switchOff();
        }
    }
}

