/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.core.handler.KeyBindingHandler;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityBeetleLarva;
import erebus.entity.EntityBotFlyLarva;
import erebus.item.ItemMaterials;
import erebus.network.PacketPipeline;
import erebus.network.server.PacketBeetleRamAttack;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityRhinoBeetle
extends EntityTameable {
    private final EntityAINearestAttackableTarget aiNearestAttackableTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true);
    private boolean ramming;
    public int rammingCharge;
    int shagCount;

    public EntityRhinoBeetle(World world) {
        super(world);
        this.func_70105_a(2.3f, 1.4f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 0.7, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.5, ModItems.turnip, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiNearestAttackableTarget);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(31, (Object)new Byte(0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 60.0 : 60.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected String func_70639_aQ() {
        return "erebus:rhinobeetlesound";
    }

    protected String func_70621_aR() {
        return "erebus:rhinobeetlehurt";
    }

    protected String func_70673_aS() {
        return "erebus:squish";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.field_70153_n != null && this.field_70123_F;
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c(1.0f);
        if (light >= 0.0f) {
            return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D) && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean func_70692_ba() {
        return this.getTameState() == 0;
    }

    public boolean func_110164_bC() {
        return !this.func_70692_ba() && super.func_110164_bC();
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.getTameState() == 2) {
            this.func_70099_a(ItemMaterials.DATA.RHINO_RIDING_KIT.makeStack(), 0.0f);
        }
        int dropRate = 1 + this.field_70146_Z.nextInt(2 + looting);
        for (int a = 0; a < dropRate; ++a) {
            this.func_70099_a(ItemMaterials.DATA.PLATE_EXO_RHINO.makeStack(), 0.0f);
        }
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.func_70099_a(ItemMaterials.DATA.RHINO_BEETLE_HORN.makeStack(), 0.0f);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack is = player.field_71071_by.func_70448_g();
        float healingBuff = 0.0f;
        if (is != null && is.func_77973_b() == ModItems.materials && is.func_77960_j() == ItemMaterials.DATA.BEETLE_TAMING_AMULET.ordinal() && this.getTameState() == 0) {
            healingBuff = (float)(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 20.0 : 20.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
            --is.field_77994_a;
            this.setTameState((byte)1);
            this.func_70908_e(true);
            player.func_71038_i();
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiNearestAttackableTarget);
            this.func_70624_b(null);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 80.0 : 80.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
            this.func_70691_i(healingBuff);
            return true;
        }
        if (is != null && is.func_77973_b() == ModItems.materials && is.func_77960_j() == ItemMaterials.DATA.RHINO_RIDING_KIT.ordinal() && this.getTameState() == 1) {
            --is.field_77994_a;
            player.func_71038_i();
            this.setTameState((byte)2);
            return true;
        }
        if (is != null && is.func_77973_b() == ModItems.turnip && !this.shagging() && this.getTameState() != 0) {
            --is.field_77994_a;
            this.shagCount = 600;
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "erebus:beetlelarvamunch", 1.0f, 0.75f);
            return true;
        }
        if (is == null && this.getTameState() == 2) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_70078_a((Entity)this);
            }
            return true;
        }
        if (is != null && is.func_77973_b() == ModItems.materials && is.func_77960_j() == ItemMaterials.DATA.BAMBOO_SHOOT.ordinal() && this.getTameState() != 0) {
            healingBuff = (float)(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 5.0 : 5.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(healingBuff);
                this.func_70908_e(true);
                player.func_71038_i();
                --is.field_77994_a;
                if (this.func_110143_aJ() == this.func_110138_aP()) {
                    this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "erebus:beetlelarvamunch", 1.0f, 0.75f);
                }
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    public boolean shagging() {
        return this.shagCount > 0;
    }

    public void setRamAttack(boolean state) {
        this.ramming = state;
    }

    protected void func_82167_n(Entity entity) {
        if (this.field_70153_n != null && entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) && !(entity instanceof EntityBotFlyLarva) && this.ramming) {
            this.ram(entity, (float)this.getRammingCharge() * 0.2f, (float)this.getRammingCharge() * 0.4f);
            this.setRammingCharge((byte)0);
        }
        super.func_82167_n(entity);
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (this.getTameState() != 0) {
            if (entity instanceof EntityPlayer) {
                super.func_70624_b((EntityLivingBase)null);
            }
        } else {
            super.func_70624_b(entity);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getTameState() != 0 && entity instanceof EntityPlayer) {
            this.func_70624_b(null);
            return false;
        }
        return this.ram(entity, 1.0f, (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 6.0 : 6.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
    }

    private boolean ram(Entity entity, float knockback, float damage) {
        if (this.getTameState() == 0 || this.field_70153_n == null) {
            this.setRammingCharge((byte)32);
        }
        if (!this.field_70170_p.field_72995_K && entity.field_70121_D.field_72337_e >= this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b <= this.field_70121_D.field_72337_e && entity.field_70121_D.field_72336_d >= this.field_70121_D.field_72340_a - 0.25 && entity.field_70121_D.field_72340_a <= this.field_70121_D.field_72336_d + 0.25 && entity.field_70121_D.field_72334_f >= this.field_70121_D.field_72339_c - 0.25 && entity.field_70121_D.field_72339_c <= this.field_70121_D.field_72334_f + 0.25) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)damage));
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f)) * knockback), 0.4, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * knockback));
            this.field_70170_p.func_72956_a(entity, "game.player.hurt.fall.big", 1.0f, 1.0f);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, this.field_70170_p.field_73013_u.ordinal() * 50, 0));
            this.setRamAttack(false);
        }
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.ramming || this.getTameState() != 0 && this.field_70153_n != null || this.field_70170_p.func_72820_D() % 10L != 0L)) {
            this.setRammingCharge((byte)0);
        }
        if (this.shagCount > 0) {
            --this.shagCount;
        }
        if (this.field_70170_p.field_72995_K && this.ramming && !KeyBindingHandler.beetleRam.func_151470_d()) {
            PacketPipeline.sendToServer(new PacketBeetleRamAttack(false));
        }
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.field_70153_n != null) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            forward = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            this.travelSpeed(f4);
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    private void travelSpeed(float velocity) {
        if (!this.field_70170_p.field_72995_K) {
            if (velocity >= 4.0f) {
                this.setRammingCharge((byte)(this.getRammingCharge() + 1));
            } else if (velocity <= 4.0f) {
                this.setRammingCharge((byte)(this.getRammingCharge() - 1));
            }
            if (this.getRammingCharge() <= 0) {
                this.setRammingCharge((byte)0);
            }
            if (this.getRammingCharge() >= 25) {
                this.setRammingCharge((byte)25);
            }
        }
    }

    public void setRammingCharge(byte velocity) {
        this.field_70180_af.func_75692_b(30, (Object)velocity);
    }

    public byte getRammingCharge() {
        return this.field_70180_af.func_75683_a(30);
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_70153_n instanceof EntityLivingBase) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.35;
            double offSetZ = Math.cos(a) * 0.35;
            this.field_70153_n.func_70107_b(this.field_70165_t - offSetX, this.field_70163_u + 1.3 + this.field_70153_n.func_70033_W(), this.field_70161_v - offSetZ);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return this.spawnBabyAnimal(entityageable);
    }

    public boolean func_70877_b(ItemStack is) {
        if (this.getTameState() != 0) {
            return is != null && is.func_77973_b() == ModItems.turnip;
        }
        return false;
    }

    public EntityBeetleLarva spawnBabyAnimal(EntityAgeable entityageable) {
        EntityBeetleLarva entityBeetleLarva = new EntityBeetleLarva(this.field_70170_p);
        entityBeetleLarva.setTame((byte)2);
        return entityBeetleLarva;
    }

    public void setTameState(byte tameState) {
        this.field_70180_af.func_75692_b(31, (Object)tameState);
    }

    public byte getTameState() {
        return this.field_70180_af.func_75683_a(31);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("tameState", this.getTameState());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTameState(nbt.func_74771_c("tameState"));
    }
}

