/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import erebus.core.handler.configs.ConfigHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySolifugeSmall
extends EntityMob
implements IEntityAdditionalSpawnData {
    public final String[] potionName = new String[]{"Move Slowdown", "Dig Slowdown", "Confusion", "Blindness", "Hunger", "Weakness", "Poison", "Wither"};
    public final byte[] potionIds = new byte[]{2, 4, 9, 15, 17, 18, 19, 20};

    public EntitySolifugeSmall(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.5f);
        this.field_70178_ae = true;
        this.field_70728_aV = 3;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)new Byte(0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 10.0 : 10.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 1.0 : 1.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected void func_70069_a(float par1) {
    }

    public void func_70110_aj() {
    }

    protected String func_70639_aQ() {
        return "mob.spider.say";
    }

    protected String func_70621_aR() {
        return "mob.spider.say";
    }

    protected String func_70673_aS() {
        return "mob.spider.death";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    public void func_70071_h_() {
        this.func_94058_c("" + this.potionName[this.getPotionEffect()]);
        super.func_70071_h_();
    }

    protected void func_70785_a(Entity entity, float distance) {
        if (distance < 2.0f) {
            super.func_70785_a(entity, distance);
            this.func_70652_k(entity);
        }
        if (distance > 2.0f && distance < 6.0f && this.field_70146_Z.nextInt(10) == 0 && this.field_70122_E) {
            double d0 = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w = d0 / (double)f2 * 0.5 * 1.900000011920929 + this.field_70159_w * 0.7000000029802322;
            this.field_70179_y = d1 / (double)f2 * 0.5 * 1.900000011920929 + this.field_70179_y * 0.7000000029802322;
            this.field_70181_x = 0.5000000059604645;
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.field_70170_p.field_73013_u.ordinal() > 1) {
                    if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                        duration = 5;
                    } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                        duration = 10;
                    }
                }
                if (duration > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76425_a[this.potionIds[this.getPotionEffect()]].field_76415_H, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public byte getPotionEffect() {
        return this.field_70180_af.func_75683_a(25);
    }

    public void setPotionEffect(byte type) {
        this.field_70180_af.func_75692_b(25, (Object)type);
        this.field_70170_p.func_72960_a((Entity)this, (byte)25);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("effect", this.getPotionEffect());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setPotionEffect(nbt.func_74771_c("effect"));
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte((int)this.getPotionEffect());
    }

    public void readSpawnData(ByteBuf data) {
        this.setPotionEffect(data.readByte());
    }
}

