/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.entity.EntityGooBall;
import erebus.entity.EntityPoisonJet;
import erebus.entity.EntityWebSling;
import erebus.item.ItemDungeonIdols;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityUmberGolemDungeonTypes
extends EntityMob
implements IEntityAdditionalSpawnData,
IBossDisplayData {
    Block block;
    int blockMeta;
    boolean hasBlock = false;
    float hardness;
    int blockX;
    int blockY;
    int blockZ;
    int breakTime = 0;

    public EntityUmberGolemDungeonTypes(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(1.0f, 1.9f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 0.5, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70728_aV = 120;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(29, (Object)new Byte(0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    private double getAttackStrength() {
        switch (this.getType()) {
            case 0: {
                return 4.0;
            }
            case 1: {
                return 5.0;
            }
            case 2: {
                return 6.0;
            }
            case 3: {
                return 7.0;
            }
        }
        return 4.0;
    }

    private double getGolemHealth() {
        switch (this.getType()) {
            case 0: {
                return 100.0;
            }
            case 1: {
                return 150.0;
            }
            case 2: {
                return 200.0;
            }
            case 3: {
                return 250.0;
            }
        }
        return 100.0;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public void func_70110_aj() {
    }

    public boolean func_110164_bC() {
        return !this.func_70692_ba() && super.func_110164_bC();
    }

    protected String func_70673_aS() {
        return "erebus:squish";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.zombie.step", 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
        ItemDungeonIdols.IDOL type = ItemDungeonIdols.IDOL.values()[Math.max(0, Math.min(ItemDungeonIdols.IDOL.values().length, this.getType()))];
        this.func_70099_a(new ItemStack(ModItems.idols, 1, type.ordinal()), 0.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null) {
            float distance = (float)this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().field_70121_D.field_72338_b, this.func_70638_az().field_70161_v);
            if (!this.hasBlock) {
                if (this.getRangeAttackTimer() < 100 && distance > 3.0f) {
                    this.setRangeAttackTimer(this.getRangeAttackTimer() + 2);
                }
                if (this.getRangeAttackTimer() == 100 && distance > 3.0f) {
                    this.shootMissile(this.func_70638_az(), distance);
                }
            }
            if (this.oneShotMoveCheat()) {
                this.func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 0.5);
            }
            if (this.field_70123_F) {
                double direction = Math.toRadians(this.field_70761_aq);
                this.removeBlock((int)(this.field_70165_t + -Math.sin(direction) * 1.5), (int)this.field_70163_u, (int)(this.field_70161_v + Math.cos(direction) * 1.5));
                this.removeBlock((int)(this.field_70165_t + -Math.sin(direction) * 1.5), (int)this.field_70163_u + 1, (int)(this.field_70161_v + Math.cos(direction) * 1.5));
            }
        }
    }

    private boolean oneShotMoveCheat() {
        return !this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.5);
    }

    protected void removeBlock(int x, int y, int z) {
        if (!this.hasBlock && this.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150350_a) {
            this.hasBlock = true;
            this.blockX = x;
            this.blockY = y;
            this.blockZ = z;
            this.breakTime = 0;
            this.block = this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ);
            this.blockMeta = this.field_70170_p.func_72805_g(this.blockX, this.blockY, this.blockZ);
            this.hardness = this.block.func_149712_f(this.field_70170_p, this.blockX, this.blockY, this.blockZ);
        }
        if (this.hardness <= 0.0f || this.block == null || !this.canBreakBlock(this.block, this.blockMeta) || !this.isInSamePos()) {
            this.hasBlock = false;
        }
        if (this.hasBlock) {
            ++this.breakTime;
            this.block = this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ);
            this.blockMeta = this.field_70170_p.func_72805_g(this.blockX, this.blockY, this.blockZ);
            int i = (int)((float)this.breakTime / (this.hardness * 160.0f) * 10.0f);
            this.field_70170_p.func_147443_d(this.func_145782_y(), this.blockX, this.blockY, this.blockZ, i);
            if (this.field_70170_p.field_73012_v.nextInt(30) == 0) {
                this.field_70170_p.func_72889_a(null, 2001, this.blockX, this.blockY, this.blockZ, Block.func_149682_b((Block)this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ)));
            }
            if ((float)this.breakTime >= this.hardness * 160.0f) {
                Utils.dropStack(this.field_70170_p, this.blockX, this.blockY, this.blockZ, new ItemStack(this.block, 1, this.blockMeta));
                this.field_70170_p.func_147468_f(this.blockX, this.blockY, this.blockZ);
                this.breakTime = 0;
                this.hasBlock = false;
                this.field_70170_p.func_72889_a(null, 2001, this.blockX, this.blockY, this.blockZ, Block.func_149682_b((Block)this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ)));
            }
        }
    }

    protected boolean canBreakBlock(Block block, int blockMeta) {
        if (block == ModBlocks.gneiss) {
            return false;
        }
        return !block.hasTileEntity(blockMeta);
    }

    private boolean isInSamePos() {
        return (int)this.field_70165_t == (int)this.field_70142_S && (int)this.field_70163_u == (int)this.field_70137_T && (int)this.field_70161_v == (int)this.field_70136_U;
    }

    public boolean func_70652_k(Entity entity) {
        return this.Attack(entity);
    }

    protected boolean Attack(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70685_l(entity)) {
            if (this.field_70122_E) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = d1 / (double)f2 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = 0.4f;
            }
            boolean knockback = true;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? this.getAttackStrength() : this.getAttackStrength() * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f)) * (float)knockback * 0.5f), 0.4, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * (float)knockback * 0.5f));
            this.field_70170_p.func_72956_a(entity, "game.player.hurt.fall.big", 1.0f, 1.0f);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, this.field_70170_p.field_73013_u.ordinal() * 50, 0));
            return true;
        }
        return true;
    }

    public EntityThrowable getMissileType() {
        switch (this.getType()) {
            case 0: {
                return new EntityGooBall(this.field_70170_p, (EntityLiving)this);
            }
            case 1: 
            case 2: {
                return new EntityWebSling(this.field_70170_p, (EntityLiving)this);
            }
            case 3: {
                return new EntityPoisonJet(this.field_70170_p, (EntityLiving)this);
            }
        }
        return new EntityGooBall(this.field_70170_p, (EntityLiving)this);
    }

    public void shootMissile(EntityLivingBase entity, float distance) {
        this.setRangeAttackTimer(0);
        if (this.func_70685_l((Entity)entity)) {
            EntityThrowable missile = this.getMissileType();
            if (this.getType() == 1) {
                ((EntityWebSling)missile).setType((byte)0);
            }
            if (this.getType() == 2) {
                ((EntityWebSling)missile).setType((byte)2);
            }
            missile.field_70125_A -= -20.0f;
            double targetX = entity.field_70165_t + entity.field_70159_w - this.field_70165_t;
            double targetY = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f - this.field_70163_u;
            double targetZ = entity.field_70161_v + entity.field_70179_y - this.field_70161_v;
            float target = MathHelper.func_76133_a((double)(targetX * targetX + targetZ * targetZ));
            missile.func_70186_c(targetX, targetY + (double)(target * 0.1f), targetZ, 0.75f, 8.0f);
            this.field_70170_p.func_72838_d((Entity)missile);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("type", this.getType());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setType(nbt.func_74771_c("type"));
    }

    public void setType(byte isType) {
        this.field_70180_af.func_75692_b(29, (Object)isType);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? this.getGolemHealth() : this.getGolemHealth() * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? this.getAttackStrength() : this.getAttackStrength() * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
    }

    public byte getType() {
        return this.field_70180_af.func_75683_a(29);
    }

    public void setRangeAttackTimer(int size) {
        this.field_70180_af.func_75692_b(20, (Object)size);
    }

    public int getRangeAttackTimer() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte((int)this.getType());
    }

    public void readSpawnData(ByteBuf data) {
        this.setType(data.readByte());
    }
}

