/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import erebus.ModItems;
import erebus.client.render.entity.AnimationMathHelper;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityBeetle;
import erebus.entity.EntityBeetleLarva;
import erebus.entity.EntityGrasshopper;
import erebus.entity.EntityWorkerBee;
import erebus.entity.ai.EntityErebusAIAttackOnCollide;
import erebus.item.ItemMaterials;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityWasp
extends EntityMob
implements IEntityAdditionalSpawnData {
    public ChunkCoordinates currentFlightTarget;
    public float wingFloat;
    AnimationMathHelper mathWings = new AnimationMathHelper();
    private boolean areAttributesSetup = false;
    public boolean waspFlying;
    public final EntityAINearestAttackableTarget aiNearestAttackableTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true);
    public final EntityErebusAIAttackOnCollide aiAttackOnCollide = new EntityErebusAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 0.3, true);

    public EntityWasp(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiNearestAttackableTarget);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGrasshopper.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBeetle.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBeetleLarva.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityWorkerBee.class, 0, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)new Byte((byte)this.field_70146_Z.nextInt(32)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.areAttributesSetup = true;
        this.updateBossAttributes();
    }

    protected void updateBossAttributes() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            if (this.getIsBoss() == 1) {
                this.func_70105_a(2.5f, 2.0f);
                this.field_70728_aV = 25;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.9);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 60.0 : 60.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 8.0 : 8.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
            } else {
                this.func_70105_a(1.5f, 1.0f);
                this.field_70728_aV = 10;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 25.0 : 25.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 4.0 : 4.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
            }
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int func_70641_bl() {
        return 2;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected void func_70069_a(float amount) {
    }

    protected String func_70639_aQ() {
        return "erebus:waspsound";
    }

    protected String func_70621_aR() {
        return "erebus:wasphurt";
    }

    protected String func_70673_aS() {
        return "erebus:squish";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
        for (int amount = 0; amount < chance; ++amount) {
            this.func_70099_a(ItemMaterials.DATA.WASP_STING.makeStack(), 0.0f);
        }
        if (this.getIsBoss() == 1) {
            this.func_70099_a(new ItemStack(ModItems.bottleAntiVenom), 0.0f);
        }
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    public void setWaspFlying(boolean state) {
        this.waspFlying = state;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            byte i = this.getIsBoss();
            if (i == 1) {
                this.func_70105_a(2.5f, 2.0f);
                if (!this.func_94056_bM()) {
                    if (this.field_70146_Z.nextBoolean()) {
                        this.func_94058_c("Livid's Bane");
                    } else {
                        this.func_94058_c("Hornet of Despair");
                    }
                }
            } else {
                this.func_70105_a(1.5f, 1.0f);
            }
        }
        this.wingFloat = !this.isFlying() ? 0.0f : this.mathWings.swing(4.0f, 0.1f);
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    if (!this.waspFlying) {
                        this.setWaspFlying(true);
                    } else {
                        this.setWaspFlying(false);
                    }
                }
                if (this.waspFlying) {
                    this.flyAbout();
                } else {
                    this.land();
                }
            }
            if (this.func_70638_az() != null) {
                this.currentFlightTarget = new ChunkCoordinates((int)this.func_70638_az().field_70165_t, (int)((float)((int)this.func_70638_az().field_70163_u) + this.func_70638_az().func_70047_e()), (int)this.func_70638_az().field_70161_v);
                this.setWaspFlying(false);
                this.flyToTarget();
            }
        }
        super.func_70071_h_();
    }

    public void flyAbout() {
        if (!(this.currentFlightTarget == null || this.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c) && this.currentFlightTarget.field_71572_b >= 1)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.currentFlightTarget.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 10.0f) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
        }
        this.flyToTarget();
    }

    public void flyToTarget() {
        if (this.currentFlightTarget != null) {
            double targetX = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.field_70165_t;
            double targetY = (double)this.currentFlightTarget.field_71572_b + 1.0 - this.field_70163_u;
            double targetZ = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(targetY) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * (double)0.1f;
            float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70177_z += rotation;
        }
    }

    private void land() {
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            if (super.func_70652_k(entity) && entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.field_70170_p.field_73013_u.ordinal() > EnumDifficulty.EASY.ordinal()) {
                    if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                        duration = 7;
                    } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                        duration = 15;
                    }
                }
                if (duration > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public byte getIsBoss() {
        return this.field_70180_af.func_75683_a(25);
    }

    public void setIsBoss(byte boss) {
        this.field_70180_af.func_75692_b(25, (Object)boss);
        this.field_70170_p.func_72960_a((Entity)this, (byte)25);
        if (this.areAttributesSetup) {
            this.updateBossAttributes();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("mobType", this.getIsBoss());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setIsBoss(nbt.func_74771_c("mobType"));
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte((int)this.getIsBoss());
    }

    public void readSpawnData(ByteBuf data) {
        this.setIsBoss(data.readByte());
    }
}

