/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity.ai;

import erebus.ModBlocks;
import erebus.block.BlockHollowLog;
import erebus.block.bamboo.BlockBambooCrop;
import erebus.block.bamboo.BlockBambooTorch;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityBeetleLarva;
import erebus.entity.ai.EntityAIEatBlock;
import erebus.lib.EnumWood;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Blocks;

public class EntityAIEatWoodenItem
extends EntityAIEatBlock {
    private final double moveSpeed;

    public EntityAIEatWoodenItem(EntityAnimal entity, double moveSpeed, int eatSpeed) {
        super((EntityLiving)entity, null, 0, moveSpeed, eatSpeed);
        this.moveSpeed = moveSpeed;
    }

    @Override
    protected boolean canEatBlock(Block block, int blockMeta) {
        if (block == null) {
            return false;
        }
        if (block == ModBlocks.scorchedWood) {
            return false;
        }
        if (block == ModBlocks.planks && blockMeta == EnumWood.Rotten.ordinal()) {
            return false;
        }
        if (block == EnumWood.Bamboo.getSlab()) {
            return false;
        }
        if (block == EnumWood.Bamboo.getStair()) {
            return false;
        }
        if (block == ModBlocks.planks && blockMeta == EnumWood.Bamboo.ordinal()) {
            return false;
        }
        if (ConfigHandler.INSTANCE.beetleLarvaEating == 2) {
            return true;
        }
        if (block.func_149688_o() != Material.field_151575_d || block instanceof BlockLog || block instanceof BlockBambooCrop || block instanceof BlockHollowLog || block == Blocks.field_150420_aW || block == Blocks.field_150419_aX || block instanceof BlockBambooTorch) {
            return false;
        }
        return ConfigHandler.INSTANCE.beetleLarvaEating != 0 || !block.hasTileEntity(blockMeta);
    }

    @Override
    protected boolean isEntityReady() {
        return true;
    }

    @Override
    protected void moveToLocation() {
        EntityBeetleLarva beetleLarva = (EntityBeetleLarva)this.entity;
        if (!beetleLarva.isEating) {
            this.entity.func_70605_aq().func_75642_a((double)this.cropX + 0.5, (double)this.cropY, (double)this.cropZ + 0.5, this.moveSpeed);
        }
    }

    @Override
    protected void prepareToEat() {
        EntityBeetleLarva beetleLarva = (EntityBeetleLarva)this.entity;
        beetleLarva.setMoveTasks(false);
        beetleLarva.setIsEating(true);
    }

    @Override
    protected void eatingInterupted() {
        EntityBeetleLarva beetleLarva = (EntityBeetleLarva)this.entity;
        beetleLarva.setIsEating(false);
        beetleLarva.setMoveTasks(true);
    }

    @Override
    protected void afterEaten() {
        EntityBeetleLarva beetleLarva = (EntityBeetleLarva)this.entity;
        beetleLarva.field_70170_p.func_147468_f(this.cropX, this.cropY, this.cropZ);
        beetleLarva.setIsEating(false);
        beetleLarva.setMoveTasks(true);
        beetleLarva.setLarvaSize(beetleLarva.getLarvaSize() + 0.1f);
    }
}

