/*
 * Decompiled with CFR 0.152.
 */
package erebus.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import erebus.ModItems;
import erebus.client.gui.GuiSmoothieMaker;
import erebus.core.helper.Utils;
import erebus.item.ItemMaterials;
import erebus.recipes.SmoothieMakerRecipe;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class SmoothieMakerNEIHandler
extends TemplateRecipeHandler {
    public final void drawForeground(int recipe) {
        super.drawForeground(recipe);
        CachedSmoothieMakerRecipe rec = (CachedSmoothieMakerRecipe)((Object)this.arecipes.get(recipe));
        FluidStack[] fluids = rec.getFluids();
        for (int i = 0; i < fluids.length; ++i) {
            this.draw(GuiSmoothieMaker.tankPositions[i], fluids[i], 16000);
        }
    }

    void draw(Rectangle rectangle, FluidStack fluid, int capacity) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        IIcon fluidIcon = fluid.getFluid().getStillIcon();
        if (fluidIcon == null) {
            return;
        }
        GuiDraw.changeTexture((ResourceLocation)TextureMap.field_110575_b);
        int colour = fluid.getFluid().getColor(fluid);
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        int a = colour >> 24 & 0xFF;
        if (a <= 0) {
            a = 255;
        }
        GL11.glColor4f((float)r, (float)g, (float)b, (float)((float)a / 255.0f));
        GL11.glEnable((int)3042);
        int amount = Math.max(Math.min(rectangle.height, fluid.amount * rectangle.height / capacity), 1);
        int posY = rectangle.y + rectangle.height - amount;
        for (int i = 0; i < rectangle.width; i += 16) {
            for (int j = 0; j < amount; j += 16) {
                int drawWidth = Math.min(rectangle.width - i, 16);
                int drawHeight = Math.min(amount - j, 16);
                int drawX = rectangle.x + i - 5;
                int drawY = posY + j - 3;
                double minU = fluidIcon.func_94209_e();
                double maxU = fluidIcon.func_94212_f();
                double minV = fluidIcon.func_94206_g();
                double maxV = fluidIcon.func_94210_h();
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)drawX, (double)(drawY + drawHeight), 0.0, minU, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)drawY, 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV);
                tessellator.func_78374_a((double)drawX, (double)drawY, 0.0, minU, minV);
                tessellator.func_78381_a();
            }
        }
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)(rectangle.x - 5), (int)rectangle.y, (int)176, (int)41, (int)rectangle.width, (int)rectangle.height);
    }

    public void drawBackground(int index) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)3, (int)167, (int)80);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSmoothieMaker.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.erebus.smoothieMaker.name");
    }

    public String getRecipeId() {
        return "erebus.smoothieMaker";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getGuiTexture() {
        return "erebus:textures/gui/container/smoothieMaker.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(67, 38, 32, 12), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (SmoothieMakerRecipe recipe : SmoothieMakerRecipe.getRecipeList()) {
                this.arecipes.add(new CachedSmoothieMakerRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (SmoothieMakerRecipe recipe : SmoothieMakerRecipe.getRecipeList()) {
            if (!Utils.areStacksTheSame(result, recipe.getOutput(), false)) continue;
            this.arecipes.add(new CachedSmoothieMakerRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (SmoothieMakerRecipe recipe : SmoothieMakerRecipe.getRecipeList()) {
            if (!recipe.isPartOfInput(ingredient) && (ingredient.func_77973_b() != ModItems.materials || ingredient.func_77960_j() != ItemMaterials.DATA.SMOOTHIE_GLASS.ordinal())) continue;
            this.arecipes.add(new CachedSmoothieMakerRecipe(recipe));
        }
    }

    public final List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        super.handleTooltip(guiRecipe, currenttip, recipe);
        CachedSmoothieMakerRecipe crecipe = (CachedSmoothieMakerRecipe)((Object)this.arecipes.get(recipe));
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)guiRecipe)) {
            Point mouse = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mouse.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x + 5, mouse.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
            FluidStack[] fluids = crecipe.getFluids();
            for (int i = 0; i < fluids.length; ++i) {
                if (!GuiSmoothieMaker.tankPositions[i].contains(relMouse)) continue;
                currenttip.add(fluids[i].getLocalizedName());
                currenttip.add(fluids[i].amount + "mB");
            }
        }
        return currenttip;
    }

    private class CachedSmoothieMakerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> inputs;
        private final FluidStack[] fluids;
        private final PositionedStack result;

        private CachedSmoothieMakerRecipe(SmoothieMakerRecipe recipe) {
            super((TemplateRecipeHandler)SmoothieMakerNEIHandler.this);
            this.result = new PositionedStack((Object)recipe.getOutput(), 75, 60);
            this.fluids = recipe.getFluids();
            int y = 16;
            int x = 16;
            List<Object> input = Arrays.asList(recipe.getInputs());
            Collections.shuffle(input);
            this.inputs = new ArrayList<PositionedStack>();
            if (input.size() >= 1 && input.get(0) != null) {
                this.inputs.add(new PositionedStack(input.get(0), x + 26, y - 10));
            }
            if (input.size() >= 2 && input.get(1) != null) {
                this.inputs.add(new PositionedStack(input.get(1), x + 47, y + 11));
            }
            if (input.size() >= 3 && input.get(2) != null) {
                this.inputs.add(new PositionedStack(input.get(2), x + 53 + 18, y + 11));
            }
            if (input.size() >= 4 && input.get(3) != null) {
                this.inputs.add(new PositionedStack(input.get(3), x + 53 + 36 + 3, y - 10));
            }
        }

        public FluidStack[] getFluids() {
            return this.fluids;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SmoothieMakerNEIHandler.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

